/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.signature.impl;

import io.mosip.vercred.vcverifier.exception.SignatureVerificationException;
import io.mosip.vercred.vcverifier.signature.SignatureVerifier;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\r"}, d2={"Lio/mosip/vercred/vcverifier/signature/impl/ES256KSignatureVerifierImpl;", "Lio/mosip/vercred/vcverifier/signature/SignatureVerifier;", "()V", "convertRawSignatureToDER", "", "signature", "verify", "", "publicKey", "Ljava/security/PublicKey;", "signData", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "vcverifier-aar-1.3.0-rc2_release"})
public final class ES256KSignatureVerifierImpl
implements SignatureVerifier {
    @Override
    public boolean verify(@NotNull PublicKey publicKey, @NotNull byte[] signData, @Nullable byte[] signature, @Nullable BouncyCastleProvider provider) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)signData, (String)"signData");
        if (signature == null || signature.length != 64) {
            throw new SignatureVerificationException("Invalid signature length: Expected 64 bytes for R || S format");
        }
        try {
            byte[] derSignature = this.convertRawSignatureToDER(signature);
            Signature $this$verify_u24lambda_u240 = Signature.getInstance("SHA256withECDSA", (Provider)provider);
            boolean bl = false;
            $this$verify_u24lambda_u240.initVerify(publicKey);
            $this$verify_u24lambda_u240.update(signData);
            return $this$verify_u24lambda_u240.verify(derSignature);
        }
        catch (Exception e) {
            throw new SignatureVerificationException("Error while doing signature verification using ES256K algorithm: " + e.getMessage());
        }
    }

    private final byte[] convertRawSignatureToDER(byte[] signature) {
        byte[] byArray = signature;
        int n = 0;
        int n2 = 32;
        BigInteger r = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byte[] byArray2 = signature;
        n2 = 32;
        int n3 = 64;
        BigInteger s = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream derEncoder = new DataOutputStream(outputStream);
        derEncoder.writeByte(48);
        ByteArrayOutputStream seqBytes = new ByteArrayOutputStream();
        seqBytes.write(2);
        seqBytes.write(r.toByteArray().length);
        seqBytes.write(r.toByteArray());
        seqBytes.write(2);
        seqBytes.write(s.toByteArray().length);
        seqBytes.write(s.toByteArray());
        byte[] derSeq = seqBytes.toByteArray();
        derEncoder.write(derSeq.length);
        derEncoder.write(derSeq);
        byte[] byArray3 = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"toByteArray(...)");
        return byArray3;
    }
}

