/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier;

import com.apicatalog.jsonld.loader.DocumentLoader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import foundation.identity.jsonld.JsonLDObject;
import info.weboftrust.ldsignatures.LdProof;
import info.weboftrust.ldsignatures.canonicalizer.URDNA2015Canonicalizer;
import info.weboftrust.ldsignatures.util.JWSUtil;
import io.ipfs.multibase.Multibase;
import io.mosip.vercred.vcverifier.CredentialsVerifier;
import io.mosip.vercred.vcverifier.constants.CredentialFormat;
import io.mosip.vercred.vcverifier.data.PresentationVerificationResult;
import io.mosip.vercred.vcverifier.data.VCResult;
import io.mosip.vercred.vcverifier.data.VPVerificationStatus;
import io.mosip.vercred.vcverifier.data.VerificationResult;
import io.mosip.vercred.vcverifier.data.VerificationStatus;
import io.mosip.vercred.vcverifier.exception.PresentationNotSupportedException;
import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import io.mosip.vercred.vcverifier.exception.SignatureNotSupportedException;
import io.mosip.vercred.vcverifier.exception.SignatureVerificationException;
import io.mosip.vercred.vcverifier.exception.UnknownException;
import io.mosip.vercred.vcverifier.publicKey.PublicKeyGetterFactory;
import io.mosip.vercred.vcverifier.signature.impl.ED25519SignatureVerifierImpl;
import io.mosip.vercred.vcverifier.utils.Util;
import io.mosip.vercred.vcverifier.utils.UtilKt;
import java.net.URI;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/mosip/vercred/vcverifier/PresentationVerifier;", "", "()V", "credentialsVerifier", "Lio/mosip/vercred/vcverifier/CredentialsVerifier;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "getVCVerificationResults", "", "Lio/mosip/vercred/vcverifier/data/VCResult;", "verifiableCredentials", "Lorg/json/JSONArray;", "verify", "Lio/mosip/vercred/vcverifier/data/PresentationVerificationResult;", "presentation", "", "vcverifier-aar-1.3.0-rc3_release"})
@SourceDebugExtension(value={"SMAP\nPresentationVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresentationVerifier.kt\nio/mosip/vercred/vcverifier/PresentationVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1549#2:161\n1620#2,3:162\n*S KotlinDebug\n*F\n+ 1 PresentationVerifier.kt\nio/mosip/vercred/vcverifier/PresentationVerifier\n*L\n138#1:161\n138#1:162,3\n*E\n"})
public final class PresentationVerifier {
    private final Logger logger = Logger.getLogger(PresentationVerifier.class.getName());
    @NotNull
    private BouncyCastleProvider provider = new BouncyCastleProvider();
    @NotNull
    private final CredentialsVerifier credentialsVerifier = new CredentialsVerifier();

    @NotNull
    public final PresentationVerificationResult verify(@NotNull String presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        this.logger.info("Received Presentation For Verification - Start");
        VPVerificationStatus proofVerificationStatus = null;
        JsonLDObject vcJsonLdObject = null;
        try {
            JsonLDObject jsonLDObject = JsonLDObject.fromJson((String)presentation);
            Intrinsics.checkNotNullExpressionValue((Object)jsonLDObject, (String)"fromJson(...)");
            vcJsonLdObject = jsonLDObject;
        }
        catch (RuntimeException e) {
            throw new PresentationNotSupportedException("Unsupported VP Token type");
        }
        try {
            CharSequence proofValue;
            CharSequence signJWS;
            CharSequence charSequence;
            this.logger.info("Proof verification - Start");
            vcJsonLdObject.setDocumentLoader((DocumentLoader)Util.Companion.getConfigurableDocumentLoader());
            LdProof ldProof = LdProof.getFromJsonLDObject((JsonLDObject)vcJsonLdObject);
            Intrinsics.checkNotNullExpressionValue((Object)ldProof, (String)"getFromJsonLDObject(...)");
            LdProof ldProof2 = ldProof;
            byte[] canonicalHashBytes = new URDNA2015Canonicalizer().canonicalize(ldProof2, vcJsonLdObject);
            URI verificationMethod = ldProof2.getVerificationMethod();
            PublicKeyGetterFactory publicKeyGetterFactory = new PublicKeyGetterFactory();
            Intrinsics.checkNotNull((Object)verificationMethod);
            PublicKey publicKeyObj = publicKeyGetterFactory.get(verificationMethod);
            if (Intrinsics.areEqual((Object)ldProof2.getType(), (Object)"Ed25519Signature2018") && !((charSequence = (CharSequence)ldProof2.getJws()) == null || charSequence.length() == 0)) {
                String string = ldProof2.getJws();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJws(...)");
                signJWS = string;
                JWSObject jwsObject = JWSObject.parse((String)signJWS);
                byte[] signature = jwsObject.getSignature().decode();
                byte[] actualData = JWSUtil.getJwsSigningInput((JWSHeader)jwsObject.getHeader(), (byte[])canonicalHashBytes);
                ED25519SignatureVerifierImpl eD25519SignatureVerifierImpl = new ED25519SignatureVerifierImpl();
                Intrinsics.checkNotNull((Object)actualData);
                proofVerificationStatus = eD25519SignatureVerifierImpl.verify(publicKeyObj, actualData, signature, this.provider) ? VPVerificationStatus.VALID : VPVerificationStatus.INVALID;
            } else if (Intrinsics.areEqual((Object)ldProof2.getType(), (Object)"Ed25519Signature2020") && !((signJWS = (CharSequence)ldProof2.getProofValue()) == null || signJWS.length() == 0)) {
                proofValue = ldProof2.getProofValue();
                byte[] signature = Multibase.decode((String)proofValue);
                ED25519SignatureVerifierImpl eD25519SignatureVerifierImpl = new ED25519SignatureVerifierImpl();
                Intrinsics.checkNotNull((Object)canonicalHashBytes);
                proofVerificationStatus = eD25519SignatureVerifierImpl.verify(publicKeyObj, canonicalHashBytes, signature, this.provider) ? VPVerificationStatus.VALID : VPVerificationStatus.INVALID;
            } else if (Intrinsics.areEqual((Object)ldProof2.getType(), (Object)"JsonWebSignature2020") && !((proofValue = (CharSequence)ldProof2.getJws()) == null || proofValue.length() == 0)) {
                String string = ldProof2.getJws();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJws(...)");
                signJWS = string;
                JWSObject jwsObject = JWSObject.parse((String)signJWS);
                if (!Intrinsics.areEqual((Object)jwsObject.getHeader().getAlgorithm(), (Object)JWSAlgorithm.EdDSA)) {
                    throw new SignatureNotSupportedException("Unsupported jws signature algorithm");
                }
                byte[] signature = jwsObject.getSignature().decode();
                byte[] actualData = JWSUtil.getJwsSigningInput((JWSHeader)jwsObject.getHeader(), (byte[])canonicalHashBytes);
                ED25519SignatureVerifierImpl eD25519SignatureVerifierImpl = new ED25519SignatureVerifierImpl();
                Intrinsics.checkNotNull((Object)actualData);
                proofVerificationStatus = eD25519SignatureVerifierImpl.verify(publicKeyObj, actualData, signature, this.provider) ? VPVerificationStatus.VALID : VPVerificationStatus.INVALID;
            } else {
                proofVerificationStatus = VPVerificationStatus.INVALID;
            }
        }
        catch (Exception e) {
            Exception exception = e;
            if ((((exception instanceof PublicKeyNotFoundException ? true : exception instanceof IllegalStateException) ? true : exception instanceof InvalidKeySpecException) ? true : exception instanceof SignatureNotSupportedException) ? true : exception instanceof SignatureVerificationException) {
                throw e;
            }
            throw new UnknownException("Error while doing verification of verifiable presentation");
        }
        JSONArray jSONArray = new JSONObject(presentation).getJSONArray("verifiableCredential");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"getJSONArray(...)");
        List<VCResult> vcVerificationResults = this.getVCVerificationResults(jSONArray);
        return new PresentationVerificationResult(proofVerificationStatus, vcVerificationResults);
    }

    /*
     * WARNING - void declaration
     */
    private final List<VCResult> getVCVerificationResults(JSONArray verifiableCredentials) {
        void $this$mapTo$iv$iv;
        Iterable<Object> $this$map$iv = UtilKt.asIterable(verifiableCredentials);
        boolean $i$f$map = false;
        Iterable<Object> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void item;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.json.JSONObject");
            String string = ((JSONObject)item).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            VerificationResult verificationResult = this.credentialsVerifier.verify(string, CredentialFormat.LDP_VC);
            VerificationStatus singleVCVerification = Util.Companion.getVerificationStatus(verificationResult);
            collection.add(new VCResult(((JSONObject)item).toString(), singleVCVerification));
        }
        return (List)destination$iv$iv;
    }
}

