/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import io.mosip.vercred.vcverifier.credentialverifier.VerifiableCredential;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocCredentialData;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocVerifiableCredentialKt;
import io.mosip.vercred.vcverifier.credentialverifier.validator.MsoMdocValidator;
import io.mosip.vercred.vcverifier.credentialverifier.verifier.MsoMdocVerifier;
import io.mosip.vercred.vcverifier.data.ValidationStatus;
import io.mosip.vercred.vcverifier.exception.ValidationException;
import io.mosip.vercred.vcverifier.utils.Base64Decoder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/mosip/vercred/vcverifier/credentialverifier/types/msomdoc/MsoMdocVerifiableCredential;", "Lio/mosip/vercred/vcverifier/credentialverifier/VerifiableCredential;", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "parse", "Lio/mosip/vercred/vcverifier/credentialverifier/types/msomdoc/MsoMdocCredentialData;", "credential", "", "validate", "Lio/mosip/vercred/vcverifier/data/ValidationStatus;", "verify", "", "vcverifier-aar-1.3.0-rc3_release"})
public final class MsoMdocVerifiableCredential
implements VerifiableCredential {
    private final Logger logger = Logger.getLogger(MsoMdocVerifiableCredential.class.getName());

    @Override
    @NotNull
    public ValidationStatus validate(@NotNull String credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        try {
            new MsoMdocValidator().validate(credential);
            return new ValidationStatus("", "");
        }
        catch (Exception exception) {
            return exception instanceof ValidationException ? new ValidationStatus(((ValidationException)exception).getErrorMessage(), ((ValidationException)exception).getErrorCode()) : new ValidationStatus("Exception during Validation: " + exception.getMessage(), "ERR_GENERIC");
        }
    }

    @Override
    public boolean verify(@NotNull String credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        return new MsoMdocVerifier().verify(credential);
    }

    @NotNull
    public final MsoMdocCredentialData parse(@NotNull String credential) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        try {
            byArray = new Base64Decoder().decodeFromBase64UrlFormatEncoded(credential);
        }
        catch (Exception exception) {
            this.logger.severe("Error occurred while base64Url decoding the credential " + exception.getMessage());
            throw new RuntimeException("Error on decoding base64Url encoded data " + exception.getMessage());
        }
        byte[] decodedData = byArray;
        List cbors = null;
        try {
            List list = new CborDecoder((InputStream)new ByteArrayInputStream(decodedData)).decode();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"decode(...)");
            cbors = list;
        }
        catch (Exception exception) {
            this.logger.severe("Error occurred while CBOR decoding the credential " + exception.getMessage());
            throw new RuntimeException("Error on decoding CBOR encoded data " + exception.getMessage());
        }
        DataItem issuerSigned = null;
        Map documents = null;
        Object e = cbors.get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
        if (StringsKt.contains$default((CharSequence)((Map)e).getKeys().toString(), (CharSequence)"documents", (boolean)false, (int)2, null)) {
            DataItem dataItem = MsoMdocVerifiableCredentialKt.get((DataItem)cbors.get(0), "documents");
            Intrinsics.checkNotNull((Object)dataItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Array");
            Object e2 = ((Array)dataItem).getDataItems().get(0);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            documents = (Map)e2;
            Object e3 = cbors.get(0);
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            DataItem dataItem2 = MsoMdocVerifiableCredentialKt.get(MsoMdocVerifiableCredentialKt.get((DataItem)((Map)e3), "documents"), 0);
            Intrinsics.checkNotNull((Object)dataItem2, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            issuerSigned = MsoMdocVerifiableCredentialKt.get((DataItem)((Map)dataItem2), "issuerSigned");
        } else {
            Object e4 = cbors.get(0);
            Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            documents = (Map)e4;
            issuerSigned = MsoMdocVerifiableCredentialKt.get((DataItem)documents, "issuerSigned");
        }
        DataItem dataItem = MsoMdocVerifiableCredentialKt.get(issuerSigned, "issuerAuth");
        Intrinsics.checkNotNull((Object)dataItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Array");
        Array issuerAuth = (Array)dataItem;
        DataItem dataItem3 = MsoMdocVerifiableCredentialKt.get(issuerSigned, "nameSpaces");
        Intrinsics.checkNotNull((Object)dataItem3, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
        Map issuerSignedNamespaces = (Map)dataItem3;
        DataItem docType = StringsKt.contains$default((CharSequence)documents.getKeys().toString(), (CharSequence)"docType", (boolean)false, (int)2, null) ? MsoMdocVerifiableCredentialKt.get((DataItem)documents, "docType") : null;
        return new MsoMdocCredentialData(docType, new MsoMdocCredentialData.IssuerSigned(issuerAuth, issuerSignedNamespaces));
    }
}

