/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey;

import io.mosip.vercred.vcverifier.exception.PublicKeyTypeNotSupportedException;
import io.mosip.vercred.vcverifier.publicKey.impl.DidJwkPublicKeyGetter;
import io.mosip.vercred.vcverifier.publicKey.impl.DidKeyPublicKeyGetter;
import io.mosip.vercred.vcverifier.publicKey.impl.DidWebPublicKeyGetter;
import io.mosip.vercred.vcverifier.publicKey.impl.HttpsPublicKeyGetter;
import java.net.URI;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/mosip/vercred/vcverifier/publicKey/PublicKeyGetterFactory;", "", "()V", "get", "Ljava/security/PublicKey;", "verificationMethod", "Ljava/net/URI;", "vcverifier-aar-1.3.0-rc3_release"})
public final class PublicKeyGetterFactory {
    @NotNull
    public final PublicKey get(@NotNull URI verificationMethod) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)verificationMethod, (String)"verificationMethod");
        String string = verificationMethod.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String verificationMethodStr = string;
        if (StringsKt.startsWith$default((String)verificationMethodStr, (String)"did:web", (boolean)false, (int)2, null)) {
            publicKey = new DidWebPublicKeyGetter().get(verificationMethod);
        } else if (StringsKt.startsWith$default((String)verificationMethodStr, (String)"did:key", (boolean)false, (int)2, null)) {
            publicKey = new DidKeyPublicKeyGetter().get(verificationMethod);
        } else if (StringsKt.startsWith$default((String)verificationMethodStr, (String)"did:jwk", (boolean)false, (int)2, null)) {
            publicKey = new DidJwkPublicKeyGetter().get(verificationMethod);
        } else if (StringsKt.startsWith$default((String)verificationMethodStr, (String)"http", (boolean)false, (int)2, null)) {
            publicKey = new HttpsPublicKeyGetter().get(verificationMethod);
        } else {
            throw new PublicKeyTypeNotSupportedException("Public Key type is not supported");
        }
        return publicKey;
    }
}

