/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ipfs.multibase.Base58;
import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import io.mosip.vercred.vcverifier.exception.PublicKeyTypeNotSupportedException;
import io.mosip.vercred.vcverifier.utils.Base64Decoder;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\b\u0010\u001d\u001a\u00020\u001eH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0002X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"PUBLIC_KEY_ALGORITHM", "", "", "SECP256K1_PRIME_MODULUS", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "decodeSecp256k1PublicKey", "Ljava/security/spec/ECPoint;", "keyBytes", "", "getECPublicKey", "Ljava/security/PublicKey;", "jwk", "getECPublicKeyFromHex", "hexKey", "getPublicKeyFromHex", "keyType", "getPublicKeyFromJWK", "jwkStr", "getPublicKeyObjectFromPemPublicKey", "publicKeyPem", "getPublicKeyObjectFromPublicKeyMultibase", "hexStringToByteArray", "hex", "recoverYCoordinate", "Ljava/math/BigInteger;", "x", "odd", "", "secp256k1Params", "Ljava/security/spec/ECParameterSpec;", "vcverifier-aar-1.3.0-rc3_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nio/mosip/vercred/vcverifier/publicKey/UtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n3648#2,10:153\n1#3:163\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nio/mosip/vercred/vcverifier/publicKey/UtilsKt\n*L\n121#1:153,10\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static BouncyCastleProvider provider = new BouncyCastleProvider();
    @NotNull
    private static final Map<String, String> PUBLIC_KEY_ALGORITHM;
    @NotNull
    private static final String SECP256K1_PRIME_MODULUS = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F";

    @NotNull
    public static final PublicKey getPublicKeyObjectFromPemPublicKey(@NotNull String publicKeyPem, @NotNull String keyType) {
        Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        try {
            StringReader strReader = new StringReader(publicKeyPem);
            PemReader pemReader = new PemReader((Reader)strReader);
            PemObject pemObject = pemReader.readPemObject();
            byte[] pubKeyBytes = pemObject.getContent();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(PUBLIC_KEY_ALGORITHM.get(keyType), (Provider)provider);
            PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
            return publicKey;
        }
        catch (Exception e) {
            throw new PublicKeyNotFoundException("Public key object is null");
        }
    }

    @NotNull
    public static final PublicKey getPublicKeyFromJWK(@NotNull String jwkStr, @NotNull String keyType) {
        Intrinsics.checkNotNullParameter((Object)jwkStr, (String)"jwkStr");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        ObjectMapper objectMapper = new ObjectMapper();
        Object object = objectMapper.readValue(jwkStr, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        Map jwk = (Map)object;
        if (!Intrinsics.areEqual((Object)keyType, (Object)"EcdsaSecp256k1VerificationKey2019")) {
            throw new PublicKeyTypeNotSupportedException("Unsupported key type: " + keyType);
        }
        return UtilsKt.getECPublicKey(jwk);
    }

    private static final PublicKey getECPublicKey(Map<String, String> jwk) {
        String string = jwk.get("crv");
        if (string == null) {
            throw new IllegalArgumentException("Missing 'crv' field for EC key");
        }
        String curve = string;
        Base64Decoder base64Decoder = new Base64Decoder();
        String string2 = jwk.get("x");
        Intrinsics.checkNotNull((Object)string2);
        byte[] xBytes = base64Decoder.decodeFromBase64UrlFormatEncoded(string2);
        Base64Decoder base64Decoder2 = new Base64Decoder();
        String string3 = jwk.get("y");
        Intrinsics.checkNotNull((Object)string3);
        byte[] yBytes = base64Decoder2.decodeFromBase64UrlFormatEncoded(string3);
        BigInteger x = new BigInteger(1, xBytes);
        BigInteger y = new BigInteger(1, yBytes);
        ECPoint ecPoint = new ECPoint(x, y);
        if (!Intrinsics.areEqual((Object)curve, (Object)"secp256k1")) {
            throw new IllegalArgumentException("Unsupported EC curve: " + curve);
        }
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECNamedCurveSpec ecParameterSpec = new ECNamedCurveSpec(curve, ecSpec.getCurve(), ecSpec.getG(), ecSpec.getN());
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
        PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
        return publicKey;
    }

    @NotNull
    public static final PublicKey getPublicKeyObjectFromPublicKeyMultibase(@NotNull String publicKeyPem, @NotNull String keyType) {
        Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        try {
            String string = publicKeyPem.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            byte[] rawPublicKeyWithHeader = Base58.decode((String)string);
            Intrinsics.checkNotNull((Object)rawPublicKeyWithHeader);
            byte[] byArray = rawPublicKeyWithHeader;
            int n = 2;
            int n2 = rawPublicKeyWithHeader.length;
            byte[] rawPublicKey = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            byte[] byArray2 = Hex.decode((String)"302a300506032b6570032100");
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
            byte[] publicKey = ArraysKt.plus((byte[])byArray2, (byte[])rawPublicKey);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(PUBLIC_KEY_ALGORITHM.get(keyType), (Provider)provider);
            PublicKey publicKey2 = keyFactory.generatePublic(pubKeySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generatePublic(...)");
            return publicKey2;
        }
        catch (Exception e) {
            throw new PublicKeyNotFoundException("Public key object is null");
        }
    }

    @NotNull
    public static final PublicKey getPublicKeyFromHex(@NotNull String hexKey, @NotNull String keyType) {
        Intrinsics.checkNotNullParameter((Object)hexKey, (String)"hexKey");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        if (!Intrinsics.areEqual((Object)keyType, (Object)"EcdsaSecp256k1VerificationKey2019")) {
            throw new PublicKeyTypeNotSupportedException("Unsupported key type: " + keyType);
        }
        return UtilsKt.getECPublicKeyFromHex(hexKey);
    }

    @NotNull
    public static final PublicKey getECPublicKeyFromHex(@NotNull String hexKey) {
        Intrinsics.checkNotNullParameter((Object)hexKey, (String)"hexKey");
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)provider);
        byte[] keyBytes = UtilsKt.hexStringToByteArray(hexKey);
        ECPoint ecPoint = UtilsKt.decodeSecp256k1PublicKey(keyBytes);
        ECParameterSpec ecSpec = UtilsKt.secp256k1Params();
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(ecPoint, ecSpec);
        PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
        return (ECPublicKey)publicKey;
    }

    private static final byte[] hexStringToByteArray(String hex) {
        byte[] byArray = new BigInteger(hex, 16).toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        byte[] $this$dropWhile$iv = byArray;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList<Byte> list$iv = new ArrayList<Byte>();
        for (byte item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            byte it = item$iv;
            boolean bl = false;
            if (it == 0) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        return CollectionsKt.toByteArray((Collection)list$iv);
    }

    private static final ECPoint decodeSecp256k1PublicKey(byte[] keyBytes) {
        if (!(keyBytes.length == 33)) {
            boolean $i$a$-require-UtilsKt$decodeSecp256k1PublicKey$22 = false;
            String $i$a$-require-UtilsKt$decodeSecp256k1PublicKey$22 = "Invalid compressed public key length";
            throw new IllegalArgumentException($i$a$-require-UtilsKt$decodeSecp256k1PublicKey$22.toString());
        }
        byte[] $i$a$-require-UtilsKt$decodeSecp256k1PublicKey$22 = keyBytes;
        int n = 1;
        int n2 = keyBytes.length;
        BigInteger x = new BigInteger(1, ArraysKt.copyOfRange((byte[])$i$a$-require-UtilsKt$decodeSecp256k1PublicKey$22, (int)n, (int)n2));
        BigInteger y = UtilsKt.recoverYCoordinate(x, keyBytes[0] == 3);
        return new ECPoint(x, y);
    }

    private static final BigInteger recoverYCoordinate(BigInteger x, boolean odd) {
        BigInteger bigInteger;
        BigInteger p = new BigInteger(SECP256K1_PRIME_MODULUS, 16);
        BigInteger b = BigInteger.valueOf(7L);
        BigInteger rhs = x.modPow(BigInteger.valueOf(3L), p).add(b).mod(p);
        BigInteger y = rhs.modPow(p.add(BigInteger.ONE).divide(BigInteger.valueOf(4L)), p);
        if (y.testBit(0) == odd) {
            Intrinsics.checkNotNull((Object)y);
            bigInteger = y;
        } else {
            BigInteger bigInteger2 = p.subtract(y);
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"subtract(...)");
        }
        return bigInteger;
    }

    private static final ECParameterSpec secp256k1Params() {
        ECNamedCurveParameterSpec params = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        return (ECParameterSpec)new ECNamedCurveSpec("secp256k1", params.getCurve(), params.getG(), params.getN(), params.getH());
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"RsaVerificationKey2018", (Object)"RSA"), TuplesKt.to((Object)"Ed25519VerificationKey2018", (Object)"Ed25519"), TuplesKt.to((Object)"Ed25519VerificationKey2020", (Object)"Ed25519")};
        PUBLIC_KEY_ALGORITHM = MapsKt.mapOf((Pair[])pairArray);
    }
}

