/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey.impl;

import io.ipfs.multibase.Multibase;
import io.mosip.vercred.vcverifier.exception.SignatureNotSupportedException;
import io.mosip.vercred.vcverifier.exception.UnknownException;
import io.mosip.vercred.vcverifier.publicKey.PublicKeyGetter;
import java.net.URI;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/mosip/vercred/vcverifier/publicKey/impl/DidKeyPublicKeyGetter;", "Lio/mosip/vercred/vcverifier/publicKey/PublicKeyGetter;", "()V", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "get", "Ljava/security/PublicKey;", "verificationMethod", "Ljava/net/URI;", "vcverifier-aar-1.3.0-rc3_release"})
@SourceDebugExtension(value={"SMAP\nDidKeyPublicKeyGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidKeyPublicKeyGetter.kt\nio/mosip/vercred/vcverifier/publicKey/impl/DidKeyPublicKeyGetter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n731#2,9:60\n37#3,2:69\n*S KotlinDebug\n*F\n+ 1 DidKeyPublicKeyGetter.kt\nio/mosip/vercred/vcverifier/publicKey/impl/DidKeyPublicKeyGetter\n*L\n30#1:60,9\n31#1:69,2\n*E\n"})
public final class DidKeyPublicKeyGetter
implements PublicKeyGetter {
    @NotNull
    private BouncyCastleProvider provider = new BouncyCastleProvider();

    @Override
    @NotNull
    public PublicKey get(@NotNull URI verificationMethod) {
        List list;
        Intrinsics.checkNotNullParameter((Object)verificationMethod, (String)"verificationMethod");
        String string = verificationMethod.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CharSequence charSequence = string;
        Regex regex = new Regex("#");
        int n = 0;
        charSequence = (CharSequence)CollectionsKt.first((List)regex.split(charSequence, n));
        regex = new Regex("did:key:");
        n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        byte[] decodedKey = Multibase.decode((String)thisCollection$iv.toArray(new String[0])[1]);
        if (decodedKey[0] == -19 && decodedKey[1] == 1 && decodedKey.length == 34) {
            try {
                byte[] publicKeyBytes = Arrays.copyOfRange(decodedKey, 2, 34);
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519);
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, publicKeyBytes);
                byte[] encodedKey = subjectPublicKeyInfo.getEncoded();
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                KeyFactory keyFactory = KeyFactory.getInstance("EdDSA", (Provider)this.provider);
                PublicKey publicKey = keyFactory.generatePublic(keySpec);
                Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
                return publicKey;
            }
            catch (Exception e) {
                Exception exception = e;
                if ((exception instanceof IllegalStateException ? true : exception instanceof InvalidKeySpecException) ? true : exception instanceof IllegalArgumentException) {
                    throw e;
                }
                throw new UnknownException("Error while getting public key object");
            }
        }
        throw new SignatureNotSupportedException("Unsupported jws signature algorithm");
    }
}

