/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey.impl;

import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import io.mosip.vercred.vcverifier.exception.PublicKeyTypeNotSupportedException;
import io.mosip.vercred.vcverifier.networkManager.HTTP_METHOD;
import io.mosip.vercred.vcverifier.networkManager.NetworkManagerClient;
import io.mosip.vercred.vcverifier.publicKey.PublicKeyGetter;
import io.mosip.vercred.vcverifier.publicKey.UtilsKt;
import java.net.URI;
import java.security.PublicKey;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/mosip/vercred/vcverifier/publicKey/impl/HttpsPublicKeyGetter;", "Lio/mosip/vercred/vcverifier/publicKey/PublicKeyGetter;", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "get", "Ljava/security/PublicKey;", "verificationMethod", "Ljava/net/URI;", "vcverifier-aar-1.3.0-rc3_release"})
public final class HttpsPublicKeyGetter
implements PublicKeyGetter {
    private final Logger logger = Logger.getLogger(HttpsPublicKeyGetter.class.getName());

    @Override
    @NotNull
    public PublicKey get(@NotNull URI verificationMethod) {
        Intrinsics.checkNotNullParameter((Object)verificationMethod, (String)"verificationMethod");
        try {
            String string = verificationMethod.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Map response = NetworkManagerClient.Companion.sendHTTPRequest$default(NetworkManagerClient.Companion, string, HTTP_METHOD.GET, null, null, 12, null);
            if (response != null) {
                PublicKey publicKey;
                Map it = response;
                boolean bl = false;
                String publicKeyStr = String.valueOf(it.get("publicKeyPem"));
                String keyType = String.valueOf(it.get("type"));
                if (it.containsKey("publicKeyJwk")) {
                    publicKey = UtilsKt.getPublicKeyFromJWK(publicKeyStr, keyType);
                } else if (it.containsKey("publicKeyHex")) {
                    publicKey = UtilsKt.getPublicKeyFromHex(publicKeyStr, keyType);
                } else if (it.containsKey("publicKeyPem")) {
                    publicKey = UtilsKt.getPublicKeyObjectFromPemPublicKey(publicKeyStr, keyType);
                } else if (it.containsKey("publicKeyMultibase")) {
                    publicKey = UtilsKt.getPublicKeyObjectFromPublicKeyMultibase(publicKeyStr, keyType);
                } else {
                    throw new PublicKeyTypeNotSupportedException("Public Key type is not supported");
                }
                return publicKey;
            }
            throw new PublicKeyNotFoundException("Public key string not found");
        }
        catch (Exception e) {
            this.logger.severe("Error fetching public key string " + e);
            throw new PublicKeyNotFoundException("Public key string not found");
        }
    }
}

