/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.credentialverifier.validator;

import io.mosip.vercred.vcverifier.data.DATA_MODEL;
import io.mosip.vercred.vcverifier.data.ValidationStatus;
import io.mosip.vercred.vcverifier.exception.ValidationException;
import io.mosip.vercred.vcverifier.utils.DateUtils;
import io.mosip.vercred.vcverifier.utils.Util;
import io.mosip.vercred.vcverifier.utils.ValidationHelper;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/mosip/vercred/vcverifier/credentialverifier/validator/LdpValidator;", "", "()V", "allFieldsWithIDAndType", "", "", "commonMandatoryFields", "dateUtils", "Lio/mosip/vercred/vcverifier/utils/DateUtils;", "validationHelper", "Lio/mosip/vercred/vcverifier/utils/ValidationHelper;", "validate", "Lio/mosip/vercred/vcverifier/data/ValidationStatus;", "credential", "validateCommonFields", "", "vcJsonObject", "Lorg/json/JSONObject;", "validateV1SpecificFields", "validateV2SpecificFields", "vcverifier-aar-1.3.0_release"})
@SourceDebugExtension(value={"SMAP\nLdpValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LdpValidator.kt\nio/mosip/vercred/vcverifier/credentialverifier/validator/LdpValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1855#2,2:170\n1855#2,2:172\n*S KotlinDebug\n*F\n+ 1 LdpValidator.kt\nio/mosip/vercred/vcverifier/credentialverifier/validator/LdpValidator\n*L\n117#1:170,2\n140#1:172,2\n*E\n"})
public final class LdpValidator {
    @NotNull
    private final List<String> commonMandatoryFields;
    @NotNull
    private final List<String> allFieldsWithIDAndType;
    @NotNull
    private final ValidationHelper validationHelper;
    @NotNull
    private final DateUtils dateUtils;

    public LdpValidator() {
        Object[] objectArray = new String[]{"@context", "type", "credentialSubject", "issuer", "proof"};
        this.commonMandatoryFields = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"proof", "credentialStatus", "evidence", "credentialSchema", "refreshService", "termsOfUse"};
        this.allFieldsWithIDAndType = CollectionsKt.listOf((Object[])objectArray);
        this.validationHelper = new ValidationHelper();
        this.dateUtils = DateUtils.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ValidationStatus validate(@NotNull String credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        try {
            if (((CharSequence)credential).length() == 0) {
                throw new ValidationException("Validation Error: Input VC JSON string is null or empty.", "ERR_EMPTY_VC");
            }
            vcJsonObject = new JSONObject(credential);
            v0 = new Util().getContextVersion(vcJsonObject);
            if (v0 == null) {
                v1 = "@context".toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toUpperCase(...)");
                throw new ValidationException("Validation Error: Missing required field: @context", "ERR_MISSING_" + v1);
            }
            contextVersion = v0;
            switch (WhenMappings.$EnumSwitchMapping$0[contextVersion.ordinal()]) {
                case 1: {
                    this.validateV1SpecificFields(vcJsonObject);
                    this.validateCommonFields(vcJsonObject);
                    if (!vcJsonObject.has("expirationDate")) ** GOTO lbl-1000
                    v2 = vcJsonObject.optString("expirationDate");
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"optString(...)");
                    if (this.dateUtils.isVCExpired(v2)) {
                        v3 = "VC is expired";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = expirationMessage = "";
                    }
                    if (!vcJsonObject.has("expirationDate")) ** GOTO lbl-1000
                    v4 = vcJsonObject.optString("expirationDate");
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"optString(...)");
                    if (this.dateUtils.isVCExpired(v4)) {
                        v5 = "ERR_VC_EXPIRED";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = "";
                    }
                    verificationStatusCode = v5;
                    return new ValidationStatus(expirationMessage, verificationStatusCode);
                }
                case 2: {
                    this.validateV2SpecificFields(vcJsonObject);
                    this.validateCommonFields(vcJsonObject);
                    if (!vcJsonObject.has("validUntil")) ** GOTO lbl-1000
                    v6 = vcJsonObject.optString("validUntil");
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"optString(...)");
                    if (this.dateUtils.isVCExpired(v6)) {
                        v7 = "VC is expired";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = expirationMessage = "";
                    }
                    if (!vcJsonObject.has("validUntil")) ** GOTO lbl-1000
                    v8 = vcJsonObject.optString("validUntil");
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"optString(...)");
                    if (this.dateUtils.isVCExpired(v8)) {
                        v9 = "ERR_VC_EXPIRED";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v9 = "";
                    }
                    verificationStatusCode = v9;
                    return new ValidationStatus(expirationMessage, verificationStatusCode);
                }
            }
            v10 = "@context".toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"toUpperCase(...)");
            throw new ValidationException("Validation Error: https://www.w3.org/2018/credentials/v1 or https://www.w3.org/ns/credentials/v2 needs to be first in the list of contexts.", "ERR_INVALID_" + v10);
        }
        catch (ValidationException e) {
            return new ValidationStatus(e.getErrorMessage(), e.getErrorCode());
        }
        catch (Exception e) {
            return new ValidationStatus("Exception during Validation: " + e.getMessage(), "ERR_GENERIC");
        }
    }

    private final void validateV1SpecificFields(JSONObject vcJsonObject) {
        List v1SpecificMandatoryFields = CollectionsKt.listOf((Object)"issuanceDate");
        this.validationHelper.checkMandatoryFields(vcJsonObject, CollectionsKt.plus((Collection)this.commonMandatoryFields, (Iterable)v1SpecificMandatoryFields));
        this.dateUtils.validateV1DateFields(vcJsonObject);
        Object[] objectArray = new String[]{"credentialStatus", "refreshService", "credentialSchema"};
        List v1SpecificIdMandatoryFields = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = this.allFieldsWithIDAndType;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String field = (String)element$iv;
            boolean bl = false;
            if (!vcJsonObject.has(field)) continue;
            this.validationHelper.validateFieldsByIdAndType(vcJsonObject, field, v1SpecificIdMandatoryFields);
        }
    }

    private final void validateV2SpecificFields(JSONObject vcJsonObject) {
        this.validationHelper.checkMandatoryFields(vcJsonObject, this.commonMandatoryFields);
        this.dateUtils.validateV2DateFields(vcJsonObject);
        List v2SpecificIdMandatoryFields = CollectionsKt.listOf((Object)"credentialSchema");
        Iterable $this$forEach$iv = this.allFieldsWithIDAndType;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String field = (String)element$iv;
            boolean bl = false;
            if (!vcJsonObject.has(field)) continue;
            this.validationHelper.validateFieldsByIdAndType(vcJsonObject, field, v2SpecificIdMandatoryFields);
        }
        this.validationHelper.validateNameAndDescription(vcJsonObject);
    }

    private final void validateCommonFields(JSONObject vcJsonObject) {
        this.validationHelper.validateCredentialSubject(vcJsonObject);
        String string = vcJsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.validationHelper.validateProof(string);
        this.validationHelper.validateId(vcJsonObject);
        this.validationHelper.validateType(vcJsonObject);
        this.validationHelper.validateIssuer(vcJsonObject);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DATA_MODEL.values().length];
            try {
                nArray[DATA_MODEL.DATA_MODEL_1_1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DATA_MODEL.DATA_MODEL_2_0.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

