/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.credentialverifier.validator;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocCredentialData;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocCredentialDataKt;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocVerifiableCredential;
import io.mosip.vercred.vcverifier.credentialverifier.validator.MsoMdocValidatorKt;
import io.mosip.vercred.vcverifier.exception.UnknownException;
import io.mosip.vercred.vcverifier.exception.ValidationException;
import io.mosip.vercred.vcverifier.utils.DateUtils;
import java.util.Date;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/mosip/vercred/vcverifier/credentialverifier/validator/MsoMdocValidator;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "validate", "", "credential", "", "vcverifier-aar-1.3.0_release"})
public final class MsoMdocValidator {
    private final Logger logger = Logger.getLogger(MsoMdocValidator.class.getName());

    public final boolean validate(@NotNull String credential) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        try {
            boolean isValidUntilGreaterThanValidFrom;
            MsoMdocCredentialData.IssuerSigned issuerSigned = new MsoMdocVerifiableCredential().parse(credential).component2();
            DataItem dataItem = MsoMdocValidatorKt.get((DataItem)MsoMdocCredentialDataKt.extractMso(issuerSigned.getIssuerAuth()), "validityInfo");
            Intrinsics.checkNotNull((Object)dataItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            Map validityInfo = (Map)dataItem;
            DataItem validFrom = MsoMdocValidatorKt.get((DataItem)validityInfo, "validFrom");
            DataItem validUntil = MsoMdocValidatorKt.get((DataItem)validityInfo, "validUntil");
            if (validUntil == null || validFrom == null) {
                this.logger.severe("validUntil / validFrom is not available in the credential's MSO");
                throw new ValidationException("invalid validUntil / validFrom in the MSO of the credential", "ERR_INVALID_DATE_MSO");
            }
            boolean isValidFromIsFutureDate = DateUtils.isFutureDateWithTolerance$default(DateUtils.INSTANCE, validFrom.toString(), 0L, 2, null);
            boolean isValidUntilIsPastDate = !DateUtils.isFutureDateWithTolerance$default(DateUtils.INSTANCE, validUntil.toString(), 0L, 2, null);
            Date date = DateUtils.INSTANCE.parseDate(validUntil.toString());
            if (date != null) {
                Date date2 = DateUtils.INSTANCE.parseDate(validFrom.toString());
                if (date2 == null) {
                    return false;
                }
                v3 = date.after(date2);
            } else {
                v3 = isValidUntilGreaterThanValidFrom = false;
            }
            if (isValidFromIsFutureDate) {
                this.logger.severe("Error while doing validity verification - invalid validFrom in the MSO of the credential");
                throw new ValidationException("invalid validFrom in the MSO of the credential", "ERR_INVALID_VALID_FROM_MSO");
            }
            if (isValidUntilIsPastDate) {
                this.logger.severe("Error while doing validity verification - invalid validUntil in the MSO of the credential");
                throw new ValidationException("invalid validUntil in the MSO of the credential", "ERR_INVALID_VALID_UNTIL_MSO");
            }
            if (!isValidUntilGreaterThanValidFrom) {
                this.logger.severe("Error while doing validity verification - invalid validFrom / validUntil in the MSO of the credential");
                throw new ValidationException("invalid validUntil / validFrom in the MSO of the credential", "ERR_INVALID_DATE_MSO");
            }
            return true;
        }
        catch (Exception exception) {
            if (exception instanceof ValidationException) {
                throw exception;
            }
            throw new UnknownException("Error while doing validation of credential - " + exception.getMessage());
        }
    }
}

