/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.credentialverifier.verifier;

import com.apicatalog.jsonld.loader.DocumentLoader;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import foundation.identity.jsonld.ConfigurableDocumentLoader;
import foundation.identity.jsonld.JsonLDObject;
import info.weboftrust.ldsignatures.LdProof;
import info.weboftrust.ldsignatures.canonicalizer.URDNA2015Canonicalizer;
import info.weboftrust.ldsignatures.util.JWSUtil;
import io.ipfs.multibase.Multibase;
import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import io.mosip.vercred.vcverifier.exception.SignatureNotSupportedException;
import io.mosip.vercred.vcverifier.exception.SignatureVerificationException;
import io.mosip.vercred.vcverifier.exception.UnknownException;
import io.mosip.vercred.vcverifier.publicKey.PublicKeyGetterFactory;
import io.mosip.vercred.vcverifier.signature.SignatureVerifier;
import io.mosip.vercred.vcverifier.signature.impl.ED25519SignatureVerifierImpl;
import io.mosip.vercred.vcverifier.signature.impl.ES256KSignatureVerifierImpl;
import io.mosip.vercred.vcverifier.signature.impl.PS256SignatureVerifierImpl;
import io.mosip.vercred.vcverifier.signature.impl.RS256SignatureVerifierImpl;
import io.mosip.vercred.vcverifier.utils.Util;
import java.net.URI;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/mosip/vercred/vcverifier/credentialverifier/verifier/LdpVerifier;", "", "()V", "SIGNATURE_VERIFIER", "", "", "Lio/mosip/vercred/vcverifier/signature/SignatureVerifier;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "verify", "", "credential", "vcverifier-aar-1.3.0_release"})
public final class LdpVerifier {
    private final Logger logger = Logger.getLogger(LdpVerifier.class.getName());
    @NotNull
    private BouncyCastleProvider provider = new BouncyCastleProvider();
    @NotNull
    private final Map<String, SignatureVerifier> SIGNATURE_VERIFIER;

    public LdpVerifier() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PS256", (Object)new PS256SignatureVerifierImpl()), TuplesKt.to((Object)"RS256", (Object)new RS256SignatureVerifierImpl()), TuplesKt.to((Object)"EdDSA", (Object)new ED25519SignatureVerifierImpl()), TuplesKt.to((Object)"ES256K", (Object)new ES256KSignatureVerifierImpl())};
        this.SIGNATURE_VERIFIER = MapsKt.mapOf((Pair[])pairArray);
        Security.addProvider((Provider)this.provider);
    }

    public final boolean verify(@NotNull String credential) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        this.logger.info("Received Credentials Verification - Start");
        ConfigurableDocumentLoader confDocumentLoader = Util.Companion.getConfigurableDocumentLoader();
        JsonLDObject jsonLDObject = JsonLDObject.fromJson((String)credential);
        Intrinsics.checkNotNullExpressionValue((Object)jsonLDObject, (String)"fromJson(...)");
        JsonLDObject vcJsonLdObject = jsonLDObject;
        vcJsonLdObject.setDocumentLoader((DocumentLoader)confDocumentLoader);
        try {
            CharSequence signJWS;
            LdProof ldProof = LdProof.getFromJsonLDObject((JsonLDObject)vcJsonLdObject);
            Intrinsics.checkNotNullExpressionValue((Object)ldProof, (String)"getFromJsonLDObject(...)");
            LdProof ldProof2 = ldProof;
            URDNA2015Canonicalizer canonicalizer = new URDNA2015Canonicalizer();
            byte[] canonicalHashBytes = canonicalizer.canonicalize(ldProof2, vcJsonLdObject);
            URI verificationMethod = ldProof2.getVerificationMethod();
            PublicKeyGetterFactory publicKeyGetterFactory = new PublicKeyGetterFactory();
            Intrinsics.checkNotNull((Object)verificationMethod);
            PublicKey publicKeyObj = publicKeyGetterFactory.get(verificationMethod);
            CharSequence charSequence = ldProof2.getJws();
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = ldProof2.getJws();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJws(...)");
                signJWS = string;
                JWSObject jwsObject = JWSObject.parse((String)signJWS);
                byte[] signature = jwsObject.getSignature().decode();
                byte[] actualData = JWSUtil.getJwsSigningInput((JWSHeader)jwsObject.getHeader(), (byte[])canonicalHashBytes);
                SignatureVerifier signatureVerifier = this.SIGNATURE_VERIFIER.get(jwsObject.getHeader().getAlgorithm().getName());
                if (signatureVerifier == null) {
                    throw new SignatureNotSupportedException("Unsupported jws signature algorithm");
                }
                SignatureVerifier signatureVerifier2 = signatureVerifier;
                Intrinsics.checkNotNull((Object)actualData);
                return signatureVerifier2.verify(publicKeyObj, actualData, signature, this.provider);
            }
            signJWS = ldProof2.getProofValue();
            if (!(signJWS == null || signJWS.length() == 0)) {
                String proofValue = ldProof2.getProofValue();
                byte[] signature = Multibase.decode((String)proofValue);
                ED25519SignatureVerifierImpl signatureVerifier = new ED25519SignatureVerifierImpl();
                Intrinsics.checkNotNull((Object)canonicalHashBytes);
                return signatureVerifier.verify(publicKeyObj, canonicalHashBytes, signature, this.provider);
            }
            bl = false;
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof PublicKeyNotFoundException ? true : exception instanceof SignatureVerificationException) {
                throw e;
            }
            throw new UnknownException("Error while doing verification of verifiable credential");
        }
        return bl;
    }
}

