/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.credentialverifier.verifier;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocCredentialData;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocCredentialDataKt;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocVerifiableCredential;
import io.mosip.vercred.vcverifier.exception.InvalidPropertyException;
import io.mosip.vercred.vcverifier.exception.LikelyTamperedException;
import io.mosip.vercred.vcverifier.exception.SignatureVerificationException;
import io.mosip.vercred.vcverifier.exception.UnknownException;
import io.mosip.vercred.vcverifier.signature.SignatureVerifier;
import io.mosip.vercred.vcverifier.signature.impl.CoseSignatureVerifierImpl;
import io.mosip.vercred.vcverifier.utils.CborDataItemUtils;
import io.mosip.vercred.vcverifier.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J\u0015\u0010\u001e\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0086\u0002J\u0015\u0010\u001e\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010!\u001a\u00020\u0013H\u0086\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/mosip/vercred/vcverifier/credentialverifier/verifier/MsoMdocVerifier;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "util", "Lio/mosip/vercred/vcverifier/utils/Util;", "extractCertificate", "Ljava/security/cert/X509Certificate;", "coseSignature", "Lco/nstant/in/cbor/model/DataItem;", "toX509Certificate", "certificateString", "verificationOfCoseSignature", "", "issuerAuth", "verify", "base64EncodedMdoc", "", "verifyCertificateChain", "Lco/nstant/in/cbor/model/Array;", "verifyCountryName", "issuerSignedNamespaces", "Lco/nstant/in/cbor/model/Map;", "Lio/mosip/vercred/vcverifier/credentialverifier/types/msomdoc/IssuerSignedNamespaces;", "verifyDocType", "mso", "docTypeInDocuments", "verifyValueDigests", "get", "index", "", "name", "vcverifier-aar-1.3.0_release"})
@SourceDebugExtension(value={"SMAP\nMsoMdocVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsoMdocVerifier.kt\nio/mosip/vercred/vcverifier/credentialverifier/verifier/MsoMdocVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1855#2:216\n1855#2,2:217\n1855#2,2:219\n1856#2:221\n*S KotlinDebug\n*F\n+ 1 MsoMdocVerifier.kt\nio/mosip/vercred/vcverifier/credentialverifier/verifier/MsoMdocVerifier\n*L\n156#1:216\n164#1:217,2\n185#1:219,2\n156#1:221\n*E\n"})
public final class MsoMdocVerifier {
    private final Logger logger = Logger.getLogger(MsoMdocVerifier.class.getName());
    @NotNull
    private final Util util = new Util();

    public final boolean verify(@NotNull String base64EncodedMdoc) {
        Intrinsics.checkNotNullParameter((Object)base64EncodedMdoc, (String)"base64EncodedMdoc");
        try {
            MsoMdocCredentialData msoMdocCredentialData = new MsoMdocVerifiableCredential().parse(base64EncodedMdoc);
            DataItem docType = msoMdocCredentialData.component1();
            MsoMdocCredentialData.IssuerSigned issuerSigned = msoMdocCredentialData.component2();
            Map mobileSecurityObject = MsoMdocCredentialDataKt.extractMso(issuerSigned.getIssuerAuth());
            Array array = issuerSigned.getIssuerAuth();
            Intrinsics.checkNotNull((Object)array);
            return this.verifyCertificateChain(array) && this.verifyCountryName((DataItem)issuerSigned.getIssuerAuth(), issuerSigned.getNamespaces()) && this.verificationOfCoseSignature((DataItem)issuerSigned.getIssuerAuth()) && this.verifyValueDigests(issuerSigned.getNamespaces(), mobileSecurityObject) && this.verifyDocType(mobileSecurityObject, docType);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if ((exception2 instanceof SignatureVerificationException ? true : exception2 instanceof LikelyTamperedException) ? true : exception2 instanceof InvalidPropertyException) {
                throw exception;
            }
            throw new UnknownException("Error while doing verification of credential - " + exception.getMessage());
        }
    }

    private final boolean verifyCertificateChain(Array issuerAuth) {
        return true;
    }

    private final boolean verifyCountryName(DataItem issuerAuth, Map issuerSignedNamespaces) {
        X509Certificate x509Certificate = this.extractCertificate(issuerAuth);
        if (x509Certificate == null) {
            throw new SignatureVerificationException("certificate chain is empty");
        }
        X509Certificate issuerCertificate = x509Certificate;
        String string = issuerCertificate.getSubjectX500Principal().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String subjectDN = string;
        String countryName = null;
        String countryNamePattern = "C=([^,]+)";
        Pattern pattern = Pattern.compile(countryNamePattern);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pattern pattern2 = pattern;
        Matcher matcher = pattern2.matcher(subjectDN);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        if (!matcher2.find()) {
            throw new RuntimeException("CN not found in Subject DN of DS certificate");
        }
        countryName = matcher2.group(1);
        String issuingCountry = MsoMdocCredentialDataKt.extractFieldValue(issuerSignedNamespaces, "issuing_country");
        if (countryName == null || !issuingCountry.equals(countryName)) {
            throw new InvalidPropertyException("Issuing country is not valid in the credential - Mismatch in credential data and DS certificate country name dound");
        }
        return true;
    }

    private final boolean verifyDocType(Map mso, DataItem docTypeInDocuments) {
        DataItem docTypeInMso = this.get((DataItem)mso, "docType");
        if (docTypeInDocuments == null) {
            this.logger.severe("Error while doing docType property verification - docType property not found in the credential");
            throw new InvalidPropertyException("Property docType not found in the credential");
        }
        if (!Intrinsics.areEqual((Object)docTypeInMso, (Object)docTypeInDocuments)) {
            this.logger.severe("Error while doing docType property verification - Property mismatch with docType in the credential");
            throw new InvalidPropertyException("Property mismatch with docType in the credential");
        }
        return true;
    }

    private final boolean verificationOfCoseSignature(DataItem issuerAuth) {
        X509Certificate x509Certificate = this.extractCertificate(issuerAuth);
        if (x509Certificate == null) {
            throw new SignatureVerificationException("Error while doing COSE signature verification - certificate chain is empty");
        }
        X509Certificate issuerCertificate = x509Certificate;
        SignatureVerifier signatureVerifier = new CoseSignatureVerifierImpl();
        PublicKey publicKey = issuerCertificate.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublicKey(...)");
        return signatureVerifier.verify(publicKey, CborDataItemUtils.INSTANCE.toByteArray(issuerAuth), null, null);
    }

    private final X509Certificate extractCertificate(DataItem coseSignature) {
        DataItem dataItem;
        Collection certificateChain;
        Intrinsics.checkNotNull((Object)coseSignature, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Array");
        DataItem dataItem2 = this.get((DataItem)((Array)coseSignature), 1);
        Intrinsics.checkNotNull((Object)dataItem2, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
        Collection collection = certificateChain = ((Map)dataItem2).getValues();
        Integer n = collection != null ? Integer.valueOf(collection.size()) : null;
        Intrinsics.checkNotNull((Object)n);
        if (n > 1) {
            dataItem = this.get((DataItem)CollectionsKt.elementAt((Iterable)certificateChain, (int)0), 1);
        } else if (certificateChain.size() == 1) {
            dataItem = ((DataItem)CollectionsKt.elementAt((Iterable)certificateChain, (int)0)).getMajorType() == MajorType.ARRAY ? this.get((DataItem)CollectionsKt.elementAt((Iterable)certificateChain, (int)0), 1) : (DataItem)CollectionsKt.elementAt((Iterable)certificateChain, (int)0);
        } else {
            return null;
        }
        DataItem issuerCertificateString = dataItem;
        return this.toX509Certificate(issuerCertificateString);
    }

    private final X509Certificate toX509Certificate(DataItem certificateString) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Intrinsics.checkNotNullExpressionValue((Object)certificateFactory, (String)"getInstance(...)");
        CertificateFactory certFactory = certificateFactory;
        Intrinsics.checkNotNull((Object)certificateString, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.ByteString");
        Certificate certificate = certFactory.generateCertificate(new ByteArrayInputStream(((ByteString)certificateString).getBytes()));
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        return (X509Certificate)certificate;
    }

    private final boolean verifyValueDigests(Map issuerSignedNamespaces, Map mso) {
        Collection collection = issuerSignedNamespaces.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeys(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map map;
            Object element$iv22;
            List namespaceData;
            DataItem namespace = (DataItem)element$iv;
            boolean bl = false;
            MsoMdocVerifier $this$verifyValueDigests_u24lambda_u244_u24lambda_u243 = this;
            boolean bl2 = false;
            DataItem dataItem = issuerSignedNamespaces.get(namespace);
            Intrinsics.checkNotNull((Object)dataItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Array");
            Intrinsics.checkNotNullExpressionValue((Object)((Array)dataItem).getDataItems(), (String)"getDataItems(...)");
            java.util.Map calculatedDigests = new LinkedHashMap();
            java.util.Map actualDigests = new LinkedHashMap();
            Iterable $this$forEach$iv2 = namespaceData;
            boolean $i$f$forEach2 = false;
            for (Object element$iv22 : $this$forEach$iv2) {
                DataItem issuerSignedItem = (DataItem)element$iv22;
                boolean bl3 = false;
                ByteArrayOutputStream encodedIssuerSignedItem = new ByteArrayOutputStream();
                new CborEncoder((OutputStream)encodedIssuerSignedItem).encode(issuerSignedItem);
                String digestAlgorithm = $this$verifyValueDigests_u24lambda_u244_u24lambda_u243.get((DataItem)mso, "digestAlgorithm").toString();
                byte[] digest = $this$verifyValueDigests_u24lambda_u244_u24lambda_u243.util.calculateDigest(digestAlgorithm, encodedIssuerSignedItem);
                Intrinsics.checkNotNull((Object)issuerSignedItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.ByteString");
                DataItem decodedIssuerSignedItem = (DataItem)new CborDecoder((InputStream)new ByteArrayInputStream(((ByteString)issuerSignedItem).getBytes())).decode().get(0);
                Intrinsics.checkNotNull((Object)decodedIssuerSignedItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                DataItem dataItem2 = $this$verifyValueDigests_u24lambda_u244_u24lambda_u243.get((DataItem)((Map)decodedIssuerSignedItem), "digestID");
                Intrinsics.checkNotNull((Object)dataItem2, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.UnsignedInteger");
                BigInteger bigInteger = ((UnsignedInteger)dataItem2).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getValue(...)");
                Number digestId = bigInteger;
                calculatedDigests.put(digestId, digest);
            }
            DataItem dataItem3 = $this$verifyValueDigests_u24lambda_u244_u24lambda_u243.get((DataItem)mso, "valueDigests");
            Intrinsics.checkNotNull((Object)dataItem3, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            if (StringsKt.contains$default((CharSequence)((Map)dataItem3).getKeys().toString(), (CharSequence)"nameSpaces", (boolean)false, (int)2, null)) {
                DataItem dataItem4 = $this$verifyValueDigests_u24lambda_u244_u24lambda_u243.get($this$verifyValueDigests_u24lambda_u244_u24lambda_u243.get((DataItem)mso, "valueDigests"), "nameSpaces");
                Intrinsics.checkNotNull((Object)dataItem4, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                DataItem dataItem5 = ((Map)dataItem4).get(namespace);
                Intrinsics.checkNotNull((Object)dataItem5, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                map = (Map)dataItem5;
            } else {
                DataItem dataItem6 = $this$verifyValueDigests_u24lambda_u244_u24lambda_u243.get((DataItem)mso, "valueDigests");
                Intrinsics.checkNotNull((Object)dataItem6, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                DataItem dataItem7 = ((Map)dataItem6).get(namespace);
                Intrinsics.checkNotNull((Object)dataItem7, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                map = (Map)dataItem7;
            }
            Map valueDigests = map;
            Collection collection2 = valueDigests.getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getKeys(...)");
            Iterable $this$forEach$iv3 = collection2;
            boolean $i$f$forEach3 = false;
            element$iv22 = $this$forEach$iv3.iterator();
            while (element$iv22.hasNext()) {
                byte[] digest;
                Object element$iv3 = element$iv22.next();
                DataItem digestId = (DataItem)element$iv3;
                boolean bl4 = false;
                MsoMdocVerifier $this$verifyValueDigests_u24lambda_u244_u24lambda_u243_u24lambda_u242_u24lambda_u241 = $this$verifyValueDigests_u24lambda_u244_u24lambda_u243;
                boolean bl5 = false;
                DataItem dataItem8 = valueDigests.get(digestId);
                Intrinsics.checkNotNull((Object)dataItem8, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.ByteString");
                Intrinsics.checkNotNullExpressionValue((Object)((ByteString)dataItem8).getBytes(), (String)"getBytes(...)");
                java.util.Map map2 = actualDigests;
                Intrinsics.checkNotNull((Object)digestId, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.UnsignedInteger");
                BigInteger bigInteger = ((UnsignedInteger)digestId).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getValue(...)");
                map2.put(bigInteger, digest);
            }
            for (Map.Entry entry : actualDigests.entrySet()) {
                Number actualDigestId = (Number)entry.getKey();
                byte[] actualDigest = (byte[])entry.getValue();
                if (Arrays.equals(actualDigest, (byte[])calculatedDigests.get(actualDigestId))) continue;
                $this$verifyValueDigests_u24lambda_u244_u24lambda_u243.logger.severe("Error while doing valueDigests verification - mismatch in digests found");
                throw new LikelyTamperedException("valueDigests verification failed - mismatch in digests with " + actualDigestId);
            }
        }
        return true;
    }

    @NotNull
    public final DataItem get(@NotNull DataItem $this$get, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!($this$get.getMajorType() == MajorType.MAP)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Map cfr_ignored_0 = (Map)$this$get;
        DataItem dataItem = ((Map)$this$get).get((DataItem)new UnicodeString(name));
        Intrinsics.checkNotNullExpressionValue((Object)dataItem, (String)"get(...)");
        return dataItem;
    }

    @NotNull
    public final DataItem get(@NotNull DataItem $this$get, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        if (!($this$get.getMajorType() == MajorType.ARRAY)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Array cfr_ignored_0 = (Array)$this$get;
        Object e = ((Array)$this$get).getDataItems().get(index);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return (DataItem)e;
    }
}

