/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey.impl;

import com.nimbusds.jose.jwk.JWK;
import io.mosip.vercred.vcverifier.exception.UnknownException;
import io.mosip.vercred.vcverifier.publicKey.PublicKeyGetter;
import io.mosip.vercred.vcverifier.utils.Base64Decoder;
import java.net.URI;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/mosip/vercred/vcverifier/publicKey/impl/DidJwkPublicKeyGetter;", "Lio/mosip/vercred/vcverifier/publicKey/PublicKeyGetter;", "()V", "b64Decoder", "Lio/mosip/vercred/vcverifier/utils/Base64Decoder;", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "get", "Ljava/security/PublicKey;", "verificationMethod", "Ljava/net/URI;", "vcverifier-aar-1.3.0_release"})
public final class DidJwkPublicKeyGetter
implements PublicKeyGetter {
    @NotNull
    private BouncyCastleProvider provider = new BouncyCastleProvider();
    @NotNull
    private Base64Decoder b64Decoder = new Base64Decoder();

    @Override
    @NotNull
    public PublicKey get(@NotNull URI verificationMethod) {
        Intrinsics.checkNotNullParameter((Object)verificationMethod, (String)"verificationMethod");
        try {
            String string = verificationMethod.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Object[] objectArray = (String[])string;
            Regex regex = new Regex("#");
            int n = 0;
            CharSequence charSequence = (CharSequence)CollectionsKt.first((List)regex.split((CharSequence)objectArray, n));
            objectArray = new String[]{"did:jwk:"};
            objectArray = this.b64Decoder.decodeFromBase64UrlFormatEncoded((String)StringsKt.split$default((CharSequence)charSequence, (String[])objectArray, (boolean)false, (int)0, (int)6, null).get(1));
            JWK jWK = JWK.parse((String)new String((byte[])objectArray, Charsets.UTF_8));
            Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"parse(...)");
            JWK jwk = jWK;
            String string2 = jwk.toOctetKeyPair().getX().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            byte[] publicKeyBytes = this.b64Decoder.decodeFromBase64UrlFormatEncoded(string2);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, publicKeyBytes);
            byte[] encodedKey = subjectPublicKeyInfo.getEncoded();
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory keyFactory = KeyFactory.getInstance("EdDSA", (Provider)this.provider);
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
            return publicKey;
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof IllegalArgumentException ? true : exception instanceof InvalidKeySpecException) {
                throw e;
            }
            throw new UnknownException("Error while getting public key object");
        }
    }
}

