/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import foundation.identity.jsonld.ConfigurableDocumentLoader;
import io.mosip.vercred.vcverifier.data.DATA_MODEL;
import io.mosip.vercred.vcverifier.data.VerificationResult;
import io.mosip.vercred.vcverifier.data.VerificationStatus;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u0001J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001a"}, d2={"Lio/mosip/vercred/vcverifier/utils/Util;", "", "()V", "calculateDigest", "", "algorithm", "", "data", "Ljava/io/ByteArrayOutputStream;", "convertJsonToMap", "", "jsonString", "getContextVersion", "Lio/mosip/vercred/vcverifier/data/DATA_MODEL;", "vcJsonObject", "Lorg/json/JSONObject;", "getId", "obj", "isValidUri", "", "value", "jsonArrayToList", "", "jsonArray", "Lorg/json/JSONArray;", "Companion", "vcverifier-aar-1.3.0_release"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\nio/mosip/vercred/vcverifier/utils/Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1#2:101\n*E\n"})
public final class Util {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getId(@NotNull Object obj) {
        Object v;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Object object = obj;
        String string = object instanceof String ? (String)obj : (object instanceof Map ? ((v = ((Map)obj).get("id")) instanceof String ? (String)v : null) : null);
        return string;
    }

    public final boolean isValidUri(@NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            URI uri = new URI(value);
            bl = Intrinsics.areEqual((Object)uri.getScheme(), (Object)"did") || uri.getScheme() != null && uri.getHost() != null;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Object> jsonArrayToList(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        int n = jsonArray.length();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<Object> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(jsonArray.get((int)it));
        }
        return arrayList;
    }

    @Nullable
    public final DATA_MODEL getContextVersion(@NotNull JSONObject vcJsonObject) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        if (vcJsonObject.has("@context")) {
            Object contextUrl = vcJsonObject.getJSONArray("@context").get(0);
            Object object = contextUrl;
            return Intrinsics.areEqual((Object)object, (Object)"https://www.w3.org/2018/credentials/v1") ? DATA_MODEL.DATA_MODEL_1_1 : (Intrinsics.areEqual((Object)object, (Object)"https://www.w3.org/ns/credentials/v2") ? DATA_MODEL.DATA_MODEL_2_0 : DATA_MODEL.UNSUPPORTED);
        }
        return null;
    }

    @NotNull
    public final byte[] calculateDigest(@NotNull String algorithm, @NotNull ByteArrayOutputStream data) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = MessageDigest.getInstance(algorithm).digest(data.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public final Map<String, Object> convertJsonToMap(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        Object object = mapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (Map)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/mosip/vercred/vcverifier/utils/Util$Companion;", "", "()V", "getConfigurableDocumentLoader", "Lfoundation/identity/jsonld/ConfigurableDocumentLoader;", "getVerificationStatus", "Lio/mosip/vercred/vcverifier/data/VerificationStatus;", "verificationResult", "Lio/mosip/vercred/vcverifier/data/VerificationResult;", "isAndroid", "", "vcverifier-aar-1.3.0_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAndroid() {
            String string = System.getProperty("java.vm.name");
            return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Dalvik", (boolean)false, (int)2, null) : false;
        }

        @NotNull
        public final ConfigurableDocumentLoader getConfigurableDocumentLoader() {
            ConfigurableDocumentLoader confDocumentLoader = new ConfigurableDocumentLoader();
            confDocumentLoader.setEnableHttps(true);
            confDocumentLoader.setEnableHttp(true);
            confDocumentLoader.setEnableFile(false);
            return confDocumentLoader;
        }

        @NotNull
        public final VerificationStatus getVerificationStatus(@NotNull VerificationResult verificationResult) {
            Intrinsics.checkNotNullParameter((Object)verificationResult, (String)"verificationResult");
            if (verificationResult.getVerificationStatus()) {
                if (Intrinsics.areEqual((Object)verificationResult.getVerificationErrorCode(), (Object)"ERR_VC_EXPIRED")) {
                    return VerificationStatus.EXPIRED;
                }
                return VerificationStatus.SUCCESS;
            }
            return VerificationStatus.INVALID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

