/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.delegates;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.cleanup.services.RemovaltimeUpdateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AssembleUpdateRemovaltimeBatchesDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(AssembleUpdateRemovaltimeBatchesDelegate.class);
    private final RemovaltimeUpdateService removaltimeUpdateService;
    public static final VariableFactory<List<List>> ASSEMBLED_UPDATE_REMOVALTIME_BATCHES = CamundaBpmData.listVariable((String)"assembled_update_removaltime_batches", List.class);
    public static final VariableFactory<Integer> UPDATED_PROCESS_INSTANCES = CamundaBpmData.intVariable((String)"updated_process_instances");
    private static final int BATCH_SIZE = 200;

    public void execute(DelegateExecution delegateExecution) throws Exception {
        log.info("Assemble batches for update removaltime");
        List instanceIdList = this.removaltimeUpdateService.listUpdateableServiceInstances();
        List updateBatches = this.splitList(instanceIdList);
        log.info("Assembled {} batches (size {})", (Object)updateBatches.size(), (Object)200);
        ASSEMBLED_UPDATE_REMOVALTIME_BATCHES.on((VariableScope)delegateExecution).set((Object)updateBatches);
        UPDATED_PROCESS_INSTANCES.on((VariableScope)delegateExecution).set((Object)0);
    }

    private List<List> splitList(List<String> list) {
        AtomicInteger counter = new AtomicInteger();
        Collection<List<String>> result = list.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 200)).values();
        return new ArrayList<List>(result);
    }

    public AssembleUpdateRemovaltimeBatchesDelegate(RemovaltimeUpdateService removaltimeUpdateService) {
        this.removaltimeUpdateService = removaltimeUpdateService;
    }
}

