/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.services;

import io.muenchendigital.digiwf.process.instance.domain.model.ServiceInstance;
import io.muenchendigital.digiwf.process.instance.domain.service.ServiceInstanceService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CleanupProcessInstancesService {
    private static final Logger log = LoggerFactory.getLogger(CleanupProcessInstancesService.class);
    private final ServiceInstanceService serviceInstanceService;

    public void cleanup() {
        log.info("Cleaning up expired process instances");
        List instances = this.serviceInstanceService.getProcessInstanceByRemovalTimeBefore(new Date());
        for (ServiceInstance instance : instances) {
            this.serviceInstanceService.cleanupInstance(instance.getInstanceId());
        }
        log.info("Cleaned up {} instances", (Object)instances.size());
    }

    public CleanupProcessInstancesService(ServiceInstanceService serviceInstanceService) {
        this.serviceInstanceService = serviceInstanceService;
    }
}

