/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.services;

import io.muenchendigital.digiwf.cleanup.services.calculation.CleanupCalculator;
import io.muenchendigital.digiwf.process.instance.infrastructure.entity.ServiceInstanceEntity;
import io.muenchendigital.digiwf.process.instance.infrastructure.repository.ProcessInstanceInfoRepository;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemovaltimeUpdateService {
    private static final Logger log = LoggerFactory.getLogger(RemovaltimeUpdateService.class);
    private final ProcessInstanceInfoRepository processInstanceInfoRepository;
    private final CleanupCalculator cleanupCalculator;

    public List<String> listUpdateableServiceInstances() {
        List instanceList = this.processInstanceInfoRepository.findAll();
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceInstanceEntity instance : instanceList) {
            if (instance.getRemovalTime() != null || !this.cleanupCalculator.canCalculate(instance.getStartTime(), instance.getEndTime())) continue;
            result.add(instance.getInstanceId());
        }
        return result;
    }

    public boolean updateServiceInstance(String instanceId) {
        Optional instance = this.processInstanceInfoRepository.findByInstanceId(instanceId);
        if (instance.isEmpty()) {
            return false;
        }
        this.updateServiceInstanceEntity((ServiceInstanceEntity)instance.get());
        return true;
    }

    private void updateServiceInstanceEntity(ServiceInstanceEntity instance) {
        log.debug("Updating removaltime of process instance: {}", (Object)instance.getInstanceId());
        Date removaltime = this.cleanupCalculator.calculateRemovalTime(instance.getDefinitionKey(), instance.getStartTime(), instance.getEndTime());
        instance.setRemovalTime(removaltime);
        this.processInstanceInfoRepository.save((Object)instance);
        log.info("Updated removaltime of process instance {}", (Object)instance.getInstanceId());
    }

    public RemovaltimeUpdateService(ProcessInstanceInfoRepository processInstanceInfoRepository, CleanupCalculator cleanupCalculator) {
        this.processInstanceInfoRepository = processInstanceInfoRepository;
        this.cleanupCalculator = cleanupCalculator;
    }
}

