/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.cleanup.services;

import java.util.List;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TimeToLiveUpdateService {
    private static final Logger log = LoggerFactory.getLogger(TimeToLiveUpdateService.class);
    private static final int PAGE_SIZE = 100;
    private final RepositoryService repositoryService;

    public void updateResourcesHistoryTimeToLive(Integer timeToLive) {
        this.updateProcessDefinitionHistoryTimeToLive(timeToLive);
        this.updateDecisionTableHistoryTimeToLive(timeToLive);
    }

    private void updateProcessDefinitionHistoryTimeToLive(Integer timeToLive) {
        List procDefs;
        int offset = 0;
        int updateCount = 0;
        do {
            procDefs = this.queryProcessDefinitions(offset, 100);
            for (ProcessDefinition procDef : procDefs) {
                if (procDef.getHistoryTimeToLive() != null) continue;
                this.repositoryService.updateProcessDefinitionHistoryTimeToLive(procDef.getId(), timeToLive);
                log.debug("Updated TTL of process definition {}", (Object)procDef.getName());
                ++updateCount;
            }
            offset += 100;
        } while (procDefs.size() >= 100);
        log.info("Updated TTL of {} process definitions", (Object)updateCount);
    }

    private List<ProcessDefinition> queryProcessDefinitions(int offset, int maxResults) {
        long start = System.currentTimeMillis();
        List procDefs = this.repositoryService.createProcessDefinitionQuery().active().listPage(offset, maxResults);
        log.debug("Found process definitions {} to {} (took {} secs)", new Object[]{offset, offset + procDefs.size(), (System.currentTimeMillis() - start) / 1000L});
        return procDefs;
    }

    private void updateDecisionTableHistoryTimeToLive(Integer timeToLive) {
        List decisionDefs;
        int offset = 0;
        int updateCount = 0;
        do {
            decisionDefs = this.queryDecisionTables(offset, 100);
            for (DecisionDefinition decisionDefinition : decisionDefs) {
                if (decisionDefinition.getHistoryTimeToLive() != null) continue;
                this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), timeToLive);
                log.debug("Updated TTL of decision definition {}", (Object)decisionDefinition.getName());
                ++updateCount;
            }
            offset += 100;
        } while (decisionDefs.size() >= 100);
        log.info("Updated TTL of {} decision definitions", (Object)updateCount);
    }

    private List<DecisionDefinition> queryDecisionTables(int offset, int maxResults) {
        long start = System.currentTimeMillis();
        List decisionDefs = this.repositoryService.createDecisionDefinitionQuery().listPage(offset, maxResults);
        log.debug("Found decision definitions {} to {} (took {} secs)", new Object[]{offset, offset + decisionDefs.size(), (System.currentTimeMillis() - start) / 1000L});
        return decisionDefs;
    }

    public TimeToLiveUpdateService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

