/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.deployment.api.resource;

import io.muenchendigital.digiwf.deployment.api.enums.DeploymentStatus;
import io.muenchendigital.digiwf.deployment.api.mapper.DeploymentMapper;
import io.muenchendigital.digiwf.deployment.api.transport.DeploymentDto;
import io.muenchendigital.digiwf.deployment.api.transport.DeploymentStatusDto;
import io.muenchendigital.digiwf.deployment.domain.model.DeploymentStatusModel;
import io.muenchendigital.digiwf.deployment.domain.service.ModelDeploymentService;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/deployment"})
@Tag(name="DeploymentController", description="API to deploy bpmn and dmn artifacts")
public class DeploymentController {
    private final ModelDeploymentService modelDeploymentService;
    private final DeploymentMapper mapper;

    @PostMapping
    @PreAuthorize(value="hasAuthority(T(io.muenchendigital.digiwf.shared.security.AuthoritiesEnum).BACKEND_DEPLOY_RESOURCE.name())")
    public DeploymentStatusDto deployArtifacts(@Valid @RequestBody DeploymentDto deploymentDto) {
        DeploymentStatusModel status = this.modelDeploymentService.deploy(this.mapper.mapToDeploymentModel(deploymentDto));
        return new DeploymentStatusDto(status.getStatus().equals(DeploymentStatus.SUCCESSFUL.getValue()), status.getMessage());
    }

    public DeploymentController(ModelDeploymentService modelDeploymentService, DeploymentMapper mapper) {
        this.modelDeploymentService = modelDeploymentService;
        this.mapper = mapper;
    }
}

