/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.deployment.domain.service;

import io.muenchendigital.digiwf.deployment.api.enums.DeploymentStatus;
import io.muenchendigital.digiwf.deployment.domain.model.DeploymentModel;
import io.muenchendigital.digiwf.deployment.domain.model.DeploymentStatusModel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ModelDeploymentService {
    private static final Logger log = LoggerFactory.getLogger(ModelDeploymentService.class);
    private final RepositoryService repositoryService;

    public DeploymentStatusModel deploy(DeploymentModel deploymentModel) {
        try {
            Deployment deployment;
            String deploymentName = deploymentModel.getDeploymentId() + "-" + deploymentModel.getVersionId();
            String resourceName = deploymentModel.getVersionId() + "." + deploymentModel.getArtifactType().toLowerCase();
            if (deploymentModel.getArtifactType().equalsIgnoreCase("bpmn")) {
                BpmnModelInstance model = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(deploymentModel.getFile().getBytes()));
                Bpmn.validateModel((BpmnModelInstance)model);
                deployment = this.deploy(model, resourceName, deploymentName);
            } else if (deploymentModel.getArtifactType().equalsIgnoreCase("dmn")) {
                DmnModelInstance model = Dmn.readModelFromStream((InputStream)new ByteArrayInputStream(deploymentModel.getFile().getBytes()));
                Dmn.validateModel((DmnModelInstance)model);
                deployment = this.deploy(model, resourceName, deploymentName);
            } else {
                throw new RuntimeException(String.format("ArtifactType %s is not support. Provide bpmn or dmn", deploymentModel.getArtifactType()));
            }
            log.info("Deployed {} - {} successfully", (Object)deployment.getId(), (Object)deployment.getName());
            return new DeploymentStatusModel(DeploymentStatus.SUCCESSFUL.getValue(), deploymentModel.getDeploymentId(), "Deployment was successful!");
        }
        catch (RuntimeException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            return new DeploymentStatusModel(DeploymentStatus.FAILURE.getValue(), deploymentModel.getDeploymentId(), exception.getMessage());
        }
    }

    private Deployment deploy(BpmnModelInstance modelInstance, String resourceName, String deploymentName) {
        return this.repositoryService.createDeployment().addModelInstance(resourceName, modelInstance).enableDuplicateFiltering(true).name(deploymentName).deploy();
    }

    private Deployment deploy(DmnModelInstance modelInstance, String resourceName, String deploymentName) {
        return this.repositoryService.createDeployment().addModelInstance(resourceName, modelInstance).enableDuplicateFiltering(true).name(deploymentName).deploy();
    }

    public ModelDeploymentService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

