/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.engine.basis.process.duplikatepruefen;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.springframework.stereotype.Component;

@Component
public class CheckBusinessKeyDelegateV02
implements JavaDelegate {
    private final RuntimeService runtimeService;
    private final HistoryService historyService;
    public static final VariableFactory<String> EXISTING_PROCESS_INSTANCES = CamundaBpmData.stringVariable((String)"app_existing_process_instances");
    public static final VariableFactory<Boolean> PROCESSES_EXIST = CamundaBpmData.booleanVariable((String)"app_processes_exist");
    public static final VariableFactory<String> PROCESS_DEFINITION_KEY = CamundaBpmData.stringVariable((String)"app_process_definition_key");
    public static final VariableFactory<String> PROCESS_INSTANCE_ID = CamundaBpmData.stringVariable((String)"app_process_instance_id");
    public static final VariableFactory<String> PROCESS_BUSINESS_KEY = CamundaBpmData.stringVariable((String)"app_process_business_key");

    public void execute(DelegateExecution execution) throws Exception {
        String businessKey = (String)PROCESS_BUSINESS_KEY.from((VariableScope)execution).getLocal();
        String processDefintionKey = (String)PROCESS_DEFINITION_KEY.from((VariableScope)execution).getLocal();
        String processInstanceId = (String)PROCESS_INSTANCE_ID.from((VariableScope)execution).getLocal();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            PROCESSES_EXIST.on((VariableScope)execution).setLocal((Object)false);
            EXISTING_PROCESS_INSTANCES.on((VariableScope)execution).setLocal((Object)"");
            return;
        }
        List existingProcessInstances = this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessKey).processDefinitionKey(processDefintionKey).list().stream().filter(instance -> !instance.getProcessInstanceId().equals(processInstanceId)).collect(Collectors.toList());
        if (existingProcessInstances.size() == 0) {
            PROCESSES_EXIST.on((VariableScope)execution).setLocal((Object)false);
            EXISTING_PROCESS_INSTANCES.on((VariableScope)execution).setLocal((Object)"");
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String existingProcessInstancesMessage = existingProcessInstances.stream().map(instance -> (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(instance.getProcessInstanceId()).singleResult()).map(instance -> "Start Zeit: " + dateFormat.format(instance.getStartTime())).collect(Collectors.joining(", "));
        EXISTING_PROCESS_INSTANCES.on((VariableScope)execution).setLocal((Object)existingProcessInstancesMessage);
        PROCESSES_EXIST.on((VariableScope)execution).setLocal((Object)true);
    }

    public CheckBusinessKeyDelegateV02(RuntimeService runtimeService, HistoryService historyService) {
        this.runtimeService = runtimeService;
        this.historyService = historyService;
    }
}

