/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.engine.incidents;

import io.muenchendigital.digiwf.legacy.mailing.domain.model.MailTemplate;
import io.muenchendigital.digiwf.legacy.mailing.domain.service.MailingService;
import java.io.IOException;
import org.apache.logging.log4j.util.Strings;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.incident.DefaultIncidentHandler;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Incident;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class IncidentNotifierHandler
extends DefaultIncidentHandler {
    private static final Logger log = LoggerFactory.getLogger(IncidentNotifierHandler.class);
    @Autowired
    private MailingService mailingService;
    @Autowired
    @Lazy
    private RepositoryService repositoryService;
    @Value(value="${digiwf.incident.cockpitUrl:#{null}}")
    private String cockpitUrl;
    @Value(value="${digiwf.incident.fromAddress:#{null}}")
    private String fromAddress;
    @Value(value="${digiwf.incident.toAddress:#{null}}")
    private String toAddress;
    @Value(value="${digiwf.incident.environment:#{null}}")
    private String environment;

    public IncidentNotifierHandler() {
        super("failedJob");
    }

    public Incident handleIncident(IncidentContext context, String message) {
        log.warn("Incident occurred");
        IncidentEntity incidentEntity = (IncidentEntity)super.handleIncident(context, message);
        if (Strings.isEmpty((CharSequence)this.toAddress)) {
            log.debug("Notification on incidents if not configured");
            return incidentEntity;
        }
        try {
            this.sendInfoMail(incidentEntity);
        }
        catch (Exception error) {
            log.error("Die Mail f\u00fcr den Incident konnte nicht gesendet werden.", (Throwable)error);
        }
        return incidentEntity;
    }

    public void sendInfoMail(IncidentEntity incidentEntity) throws IOException {
        String processName = this.getProcessName(incidentEntity.getProcessDefinitionId());
        String link = this.cockpitUrl + "camunda/app/cockpit/default/#/process-instance/" + incidentEntity.getProcessInstanceId() + "/runtime";
        Object body = "In der Anwendung ist ein Incident aufgetreten.";
        if (!processName.isBlank()) {
            body = "In der Anwendung ist ein Incident aufgetreten (Prozessname: " + processName + ").";
        }
        MailTemplate mail = ((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)MailTemplate.builder().body((String)body)).link(link).buttonText("Fehler im Cockpit anzeigen").subject(this.environment + ": Incident aufgetreten")).receivers(this.toAddress)).replyTo(this.fromAddress)).build();
        log.debug("Sending mail");
        this.mailingService.sendMailTemplateWithLink(mail);
    }

    private String getProcessName(String processDefinitionId) {
        String processName = "";
        try {
            ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
            if (procDef.getName() != null && !procDef.getName().isBlank()) {
                processName = procDef.getName();
            } else if (procDef.getKey() != null && !procDef.getKey().isBlank()) {
                processName = procDef.getKey();
            }
        }
        catch (Exception ex) {
            log.warn("Reading ProcessDefinition failed: {}", (Object)ex.getMessage());
        }
        return processName;
    }
}

