/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.api.mapper;

import io.muenchendigital.digiwf.humantask.api.mapper.HumanTaskApiMapper;
import io.muenchendigital.digiwf.humantask.api.transport.HumanTaskDetailTO;
import io.muenchendigital.digiwf.humantask.api.transport.HumanTaskTO;
import io.muenchendigital.digiwf.humantask.domain.model.HumanTask;
import io.muenchendigital.digiwf.humantask.domain.model.HumanTaskDetail;
import io.muenchendigital.digiwf.legacy.form.api.transport.ButtonsTO;
import io.muenchendigital.digiwf.legacy.form.api.transport.FormFieldTO;
import io.muenchendigital.digiwf.legacy.form.api.transport.FormTO;
import io.muenchendigital.digiwf.legacy.form.api.transport.GroupTO;
import io.muenchendigital.digiwf.legacy.form.api.transport.ItemTO;
import io.muenchendigital.digiwf.legacy.form.api.transport.RuleTO;
import io.muenchendigital.digiwf.legacy.form.domain.model.Buttons;
import io.muenchendigital.digiwf.legacy.form.domain.model.Form;
import io.muenchendigital.digiwf.legacy.form.domain.model.FormField;
import io.muenchendigital.digiwf.legacy.form.domain.model.Group;
import io.muenchendigital.digiwf.legacy.form.domain.model.Item;
import io.muenchendigital.digiwf.legacy.form.domain.model.Rule;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class HumanTaskApiMapperImpl
implements HumanTaskApiMapper {
    public List<HumanTaskTO> map2TO(List<HumanTask> list) {
        if (list == null) {
            return null;
        }
        ArrayList<HumanTaskTO> list1 = new ArrayList<HumanTaskTO>(list.size());
        for (HumanTask humanTask : list) {
            list1.add(this.map2TO(humanTask));
        }
        return list1;
    }

    public HumanTaskTO map2TO(HumanTask task) {
        if (task == null) {
            return null;
        }
        HumanTaskTO.HumanTaskTOBuilder humanTaskTO = HumanTaskTO.builder();
        humanTaskTO.id(task.getId());
        humanTaskTO.name(task.getName());
        humanTaskTO.description(task.getDescription());
        humanTaskTO.processName(task.getProcessName());
        humanTaskTO.assignee(task.getAssignee());
        humanTaskTO.assigneeFormatted(task.getAssigneeFormatted());
        humanTaskTO.followUpDate(task.getFollowUpDate());
        humanTaskTO.creationTime(task.getCreationTime());
        return humanTaskTO.build();
    }

    public HumanTaskDetailTO map2TO(HumanTaskDetail taskDetail) {
        if (taskDetail == null) {
            return null;
        }
        HumanTaskDetailTO.HumanTaskDetailTOBuilder humanTaskDetailTO = HumanTaskDetailTO.builder();
        humanTaskDetailTO.id(taskDetail.getId());
        humanTaskDetailTO.name(taskDetail.getName());
        humanTaskDetailTO.description(taskDetail.getDescription());
        humanTaskDetailTO.processName(taskDetail.getProcessName());
        humanTaskDetailTO.processInstanceId(taskDetail.getProcessInstanceId());
        humanTaskDetailTO.assignee(taskDetail.getAssignee());
        humanTaskDetailTO.assigneeFormatted(taskDetail.getAssigneeFormatted());
        humanTaskDetailTO.followUpDate(taskDetail.getFollowUpDate());
        humanTaskDetailTO.creationTime(taskDetail.getCreationTime());
        Map map = taskDetail.getVariables();
        if (map != null) {
            humanTaskDetailTO.variables(new LinkedHashMap(map));
        }
        humanTaskDetailTO.form(this.formToFormTO(taskDetail.getForm()));
        Map map1 = taskDetail.getJsonSchema();
        if (map1 != null) {
            humanTaskDetailTO.jsonSchema(new LinkedHashMap(map1));
        }
        humanTaskDetailTO.statusDocument(taskDetail.getStatusDocument());
        return humanTaskDetailTO.build();
    }

    protected ButtonsTO buttonsToButtonsTO(Buttons buttons) {
        if (buttons == null) {
            return null;
        }
        ButtonsTO.ButtonsTOBuilder buttonsTO = ButtonsTO.builder();
        buttonsTO.complete(buttons.getComplete());
        buttonsTO.cancel(buttons.getCancel());
        buttonsTO.statusPdf(buttons.getStatusPdf());
        return buttonsTO.build();
    }

    protected ItemTO itemToItemTO(Item item) {
        if (item == null) {
            return null;
        }
        ItemTO.ItemTOBuilder itemTO = ItemTO.builder();
        itemTO.name(item.getName());
        itemTO.value(item.getValue());
        return itemTO.build();
    }

    protected List<ItemTO> itemListToItemTOList(List<Item> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ItemTO> list1 = new ArrayList<ItemTO>(list.size());
        for (Item item : list) {
            list1.add(this.itemToItemTO(item));
        }
        return list1;
    }

    protected RuleTO ruleToRuleTO(Rule rule) {
        if (rule == null) {
            return null;
        }
        RuleTO.RuleTOBuilder ruleTO = RuleTO.builder();
        ruleTO.type(rule.getType());
        ruleTO.value(rule.getValue());
        ruleTO.target(rule.getTarget());
        return ruleTO.build();
    }

    protected List<RuleTO> ruleListToRuleTOList(List<Rule> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RuleTO> list1 = new ArrayList<RuleTO>(list.size());
        for (Rule rule : list) {
            list1.add(this.ruleToRuleTO(rule));
        }
        return list1;
    }

    protected FormFieldTO formFieldToFormFieldTO(FormField formField) {
        if (formField == null) {
            return null;
        }
        FormFieldTO.FormFieldTOBuilder formFieldTO = FormFieldTO.builder();
        formFieldTO.type(formField.getType());
        formFieldTO.key(formField.getKey());
        formFieldTO.defaultValue(formField.getDefaultValue());
        formFieldTO.defaultValueField(formField.getDefaultValueField());
        formFieldTO.label(formField.getLabel());
        formFieldTO.prependIcon(formField.getPrependIcon());
        formFieldTO.tooltip(formField.getTooltip());
        formFieldTO.ext(formField.getExt());
        formFieldTO.multiple(formField.isMultiple());
        formFieldTO.description(formField.getDescription());
        formFieldTO.ldapOus(formField.getLdapOus());
        formFieldTO.imageHeight(formField.getImageHeight());
        formFieldTO.imageWidth(formField.getImageWidth());
        formFieldTO.readonly(formField.isReadonly());
        formFieldTO.rows(formField.getRows());
        formFieldTO.col(formField.getCol());
        formFieldTO.items(this.itemListToItemTOList(formField.getItems()));
        formFieldTO.rules(this.ruleListToRuleTOList(formField.getRules()));
        return formFieldTO.build();
    }

    protected List<FormFieldTO> formFieldListToFormFieldTOList(List<FormField> list) {
        if (list == null) {
            return null;
        }
        ArrayList<FormFieldTO> list1 = new ArrayList<FormFieldTO>(list.size());
        for (FormField formField : list) {
            list1.add(this.formFieldToFormFieldTO(formField));
        }
        return list1;
    }

    protected GroupTO groupToGroupTO(Group group) {
        if (group == null) {
            return null;
        }
        GroupTO.GroupTOBuilder groupTO = GroupTO.builder();
        groupTO.label(group.getLabel());
        groupTO.schema(this.formFieldListToFormFieldTOList(group.getSchema()));
        return groupTO.build();
    }

    protected List<GroupTO> groupListToGroupTOList(List<Group> list) {
        if (list == null) {
            return null;
        }
        ArrayList<GroupTO> list1 = new ArrayList<GroupTO>(list.size());
        for (Group group : list) {
            list1.add(this.groupToGroupTO(group));
        }
        return list1;
    }

    protected FormTO formToFormTO(Form form) {
        if (form == null) {
            return null;
        }
        FormTO.FormTOBuilder formTO = FormTO.builder();
        formTO.key(form.getKey());
        formTO.description(form.getDescription());
        formTO.authorizedGroups(form.getAuthorizedGroups());
        formTO.buttons(this.buttonsToButtonsTO(form.getButtons()));
        formTO.groups(this.groupListToGroupTOList(form.getGroups()));
        return formTO.build();
    }
}

