/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.api.resource;

import io.muenchendigital.digiwf.humantask.domain.service.HumanTaskFileService;
import io.muenchendigital.digiwf.shared.file.presignedUrlAdapters.PresignedUrlAction;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Transactional
@RequestMapping(value={"/rest/task/file"})
@Tag(name="HumanTaskFileRestController", description="API to perform actions on human task files")
public class HumanTaskFileRestController {
    private final HumanTaskFileService humanTaskFileService;
    private final AppAuthenticationProvider authenticationProvider;

    @GetMapping(value={"/{taskId}"})
    public ResponseEntity<List<String>> getFileNames(@PathVariable String taskId, @RequestParam String filePath) {
        List fileNames = this.humanTaskFileService.getFileNames(taskId, filePath, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)fileNames);
    }

    @GetMapping(value={"/{taskId}/{fileName}"})
    public ResponseEntity<String> getPresignedUrlForFileDownload(@PathVariable String taskId, @PathVariable String fileName, @RequestParam String filePath) {
        String presignedUrl = this.humanTaskFileService.getPresignedUrl(PresignedUrlAction.GET, taskId, filePath, fileName, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)presignedUrl);
    }

    @PostMapping(value={"/{taskId}/{filename}"})
    public ResponseEntity<String> getPresignedUrlForFileUpload(@PathVariable String taskId, @PathVariable String filename, @RequestParam String filePath) {
        String presignedUrls = this.humanTaskFileService.getPresignedUrl(PresignedUrlAction.POST, taskId, filePath, filename, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)presignedUrls);
    }

    @DeleteMapping(value={"/{taskId}/{filename}"})
    public ResponseEntity<String> getPresignedUrlForFileDeletion(@PathVariable String taskId, @PathVariable String filename, @RequestParam String filePath) {
        String presignedUrl = this.humanTaskFileService.getPresignedUrl(PresignedUrlAction.DELETE, taskId, filePath, filename, this.authenticationProvider.getCurrentUserId(), this.authenticationProvider.getCurrentUserGroups());
        return ResponseEntity.ok((Object)presignedUrl);
    }

    public HumanTaskFileRestController(HumanTaskFileService humanTaskFileService, AppAuthenticationProvider authenticationProvider) {
        this.humanTaskFileService = humanTaskFileService;
        this.authenticationProvider = authenticationProvider;
    }
}

