/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.domain.service;

import io.muenchendigital.digiwf.humantask.domain.mapper.ActRuTaskMapper;
import io.muenchendigital.digiwf.humantask.domain.mapper.HumanTaskMapper;
import io.muenchendigital.digiwf.humantask.domain.model.ActRuTask;
import io.muenchendigital.digiwf.humantask.domain.model.HumanTask;
import io.muenchendigital.digiwf.humantask.domain.model.HumanTaskDetail;
import io.muenchendigital.digiwf.humantask.domain.model.TaskInfo;
import io.muenchendigital.digiwf.humantask.domain.service.HumanTaskDataService;
import io.muenchendigital.digiwf.humantask.domain.service.TaskInfoService;
import io.muenchendigital.digiwf.humantask.infrastructure.repository.ActRuGroupTaskSearchRepository;
import io.muenchendigital.digiwf.humantask.infrastructure.repository.ActRuTaskSearchRepository;
import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import io.muenchendigital.digiwf.jsonschema.domain.service.JsonSchemaService;
import io.muenchendigital.digiwf.legacy.form.domain.service.FormService;
import io.muenchendigital.digiwf.shared.exception.IllegalResourceAccessException;
import io.muenchendigital.digiwf.shared.exception.ObjectNotFoundException;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class HumanTaskService {
    private static final Logger log = LoggerFactory.getLogger(HumanTaskService.class);
    private final HumanTaskDataService humanTaskDataService;
    private final TaskInfoService taskInfoService;
    private final ActRuTaskMapper actRuTaskMapper;
    private final ActRuGroupTaskSearchRepository actRuGroupTaskSearchRepository;
    private final ActRuTaskSearchRepository actRuTaskSearchRepository;
    private final FormService formService;
    private final JsonSchemaService jsonSchemaService;
    private final TaskService taskService;
    private final HumanTaskMapper humanTaskMapper;

    public HumanTaskDetail getDetail(String taskId, String userId, List<String> groups) {
        Task task = this.getTask(taskId);
        if (!this.hasAccess(task, userId, groups)) {
            throw new IllegalResourceAccessException(String.format("Task with id %s not accessable", taskId));
        }
        Map variables = this.humanTaskDataService.getVariablesForTask(task);
        TaskInfo taskInfo = this.taskInfoService.findByTaskId(taskId);
        HumanTaskDetail detail = this.humanTaskMapper.map2Model(task, taskInfo, variables);
        Optional form = this.formService.getForm(task.getFormKey());
        form.ifPresent(arg_0 -> ((HumanTaskDetail)detail).setForm(arg_0));
        if (form.isEmpty()) {
            JsonSchema schema = (JsonSchema)this.humanTaskDataService.getSchemaKey(task.getId()).map(arg_0 -> ((JsonSchemaService)this.jsonSchemaService).getByKey(arg_0)).orElseThrow().orElseThrow();
            detail.setJsonSchema(schema.getSchemaMap());
            detail.setStatusDocument(this.humanTaskDataService.getVariable(task.getId(), "app_task_status_dokument_enabled").map(Boolean::valueOf).orElse(false));
        }
        return detail;
    }

    public Task getTask(String id) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(id).initializeFormKeys().singleResult();
        if (task == null) {
            throw new ObjectNotFoundException(String.format("The task with the id %s is not available.", id));
        }
        return task;
    }

    public Page<HumanTask> getTasksForUser(String userId, @Nullable String query, Boolean followUp, Pageable pageable) {
        return this.getActRuTaskEntityByAssigneeId(userId, query, followUp, pageable).map(arg_0 -> ((HumanTaskMapper)this.humanTaskMapper).map2Model(arg_0));
    }

    public Page<HumanTask> getOpenGroupTasks(String userId, List<String> groups, @Nullable String query, Pageable pageable) {
        return this.getGroupTasks(userId, groups, Boolean.valueOf(false), query, pageable).map(arg_0 -> ((HumanTaskMapper)this.humanTaskMapper).map2Model(arg_0));
    }

    public Page<HumanTask> getAssignedGroupTasks(String userId, List<String> groups, @Nullable String query, Pageable pageable) {
        return this.getGroupTasks(userId, groups, Boolean.valueOf(true), query, pageable).map(arg_0 -> ((HumanTaskMapper)this.humanTaskMapper).map2Model(arg_0));
    }

    public void completeTask(String taskId, Map<String, Object> variables, String userId) {
        Task task = this.getTask(taskId);
        if (!userId.equals(task.getAssignee())) {
            throw new ObjectNotFoundException(String.format("The task with the id %s is not available.", taskId));
        }
        Map filteredVariables = this.humanTaskDataService.serializeGivenVariables(task, variables);
        this.taskService.complete(taskId, filteredVariables);
        log.info("task completed: {}", (Object)taskId);
    }

    public void saveTask(String taskId, Map<String, Object> variables, String userId) {
        Task task = this.getTask(taskId);
        if (!userId.equals(task.getAssignee())) {
            throw new ObjectNotFoundException(String.format("The task with the id %s is not available.", taskId));
        }
        Map filteredVariables = this.humanTaskDataService.serializeGivenVariables(task, variables);
        this.taskService.setVariables(taskId, filteredVariables);
    }

    public void assignTask(String taskId, String userId, List<String> groups) {
        Task task = Optional.ofNullable((Task)this.taskService.createTaskQuery().taskId(taskId).singleResult()).orElseThrow(() -> new ObjectNotFoundException(String.format("Task with the id %s is not available", taskId)));
        if (!this.hasAccess(task, userId, groups)) {
            throw new IllegalArgumentException(String.format("Task with id %s not available", taskId));
        }
        if (!StringUtils.isBlank((CharSequence)task.getAssignee()) && task.getAssignee().equals(userId)) {
            log.debug("Task {} is already assigned to {}.", (Object)taskId, (Object)userId);
            return;
        }
        this.taskService.setAssignee(taskId, userId);
    }

    public void followUp(String taskId, String followUpDate, String userId) {
        Task task = this.getTask(taskId);
        if (!userId.equals(task.getAssignee())) {
            throw new ObjectNotFoundException(String.format("The task with the id %s is not available.", taskId));
        }
        if (StringUtils.isBlank((CharSequence)followUpDate)) {
            task.setFollowUpDate(null);
        } else {
            task.setFollowUpDate((java.util.Date)Date.valueOf(followUpDate));
        }
        this.taskService.saveTask(task);
    }

    public void cancelTask(String taskId, String userId) {
        Task task = Optional.ofNullable((Task)this.taskService.createTaskQuery().taskId(taskId).singleResult()).orElseThrow(() -> new ObjectNotFoundException(String.format("Die Aufgabe mit der id %s ist nicht vorhanden", taskId)));
        if (!userId.equals(task.getAssignee())) {
            throw new ObjectNotFoundException(String.format("The task with the id %s is not available.", taskId));
        }
        this.taskService.handleBpmnError(task.getId(), "default_error_code");
    }

    public boolean hasAccess(String taskId, String userId, List<String> groups) {
        Task task = this.getTask(taskId);
        return this.hasAccess(task, userId, groups);
    }

    public boolean hasAccess(Task task, String userId, List<String> groups) {
        if (userId.equals(task.getAssignee())) {
            return true;
        }
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        return identityLinks.stream().filter(link -> "candidate".equals(link.getType())).anyMatch(link -> groups.stream().anyMatch(group -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{link.getGroupId()}) && group.equalsIgnoreCase(link.getGroupId())) || userId.equals(link.getUserId()));
    }

    private Page<ActRuTask> getActRuTaskEntityByAssigneeId(String assigneeId, @Nullable String query, Boolean followUp, Pageable pageable) {
        return this.actRuTaskSearchRepository.search(assigneeId, query, followUp, pageable).map(arg_0 -> ((ActRuTaskMapper)this.actRuTaskMapper).map2Model(arg_0));
    }

    private Page<ActRuTask> getGroupTasks(String userId, List<String> groups, Boolean assigned, @Nullable String query, Pageable pageable) {
        List lowerCaseGroups = groups.stream().map(String::toLowerCase).collect(Collectors.toList());
        return this.actRuGroupTaskSearchRepository.search(userId, lowerCaseGroups, query, assigned, pageable).map(arg_0 -> ((ActRuTaskMapper)this.actRuTaskMapper).map2Model(arg_0));
    }

    public HumanTaskService(HumanTaskDataService humanTaskDataService, TaskInfoService taskInfoService, ActRuTaskMapper actRuTaskMapper, ActRuGroupTaskSearchRepository actRuGroupTaskSearchRepository, ActRuTaskSearchRepository actRuTaskSearchRepository, FormService formService, JsonSchemaService jsonSchemaService, TaskService taskService, HumanTaskMapper humanTaskMapper) {
        this.humanTaskDataService = humanTaskDataService;
        this.taskInfoService = taskInfoService;
        this.actRuTaskMapper = actRuTaskMapper;
        this.actRuGroupTaskSearchRepository = actRuGroupTaskSearchRepository;
        this.actRuTaskSearchRepository = actRuTaskSearchRepository;
        this.formService = formService;
        this.jsonSchemaService = jsonSchemaService;
        this.taskService = taskService;
        this.humanTaskMapper = humanTaskMapper;
    }
}

