/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.domain.service;

import io.muenchendigital.digiwf.humantask.domain.mapper.TaskInfoMapper;
import io.muenchendigital.digiwf.humantask.domain.model.TaskInfo;
import io.muenchendigital.digiwf.humantask.domain.model.TaskInfoUpdate;
import io.muenchendigital.digiwf.humantask.infrastructure.entity.TaskInfoEntity;
import io.muenchendigital.digiwf.humantask.infrastructure.repository.TaskInfoRepository;
import io.muenchendigital.digiwf.humantask.process.ProcessTaskConstants;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.process.definition.domain.service.ServiceDefinitionService;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoService.class);
    private final TaskInfoRepository taskInfoRepository;
    private final TaskInfoMapper taskInfoMapper;
    private final ServiceDefinitionService serviceDefinitionService;
    private final UserService userService;

    public TaskInfo findByTaskId(String taskId) {
        return this.taskInfoRepository.findById((Object)taskId).map(arg_0 -> ((TaskInfoMapper)this.taskInfoMapper).map2Model(arg_0)).orElseThrow();
    }

    public void createTaskInfo(DelegateTask task) {
        ProcessDefinition definition = this.getProcessDefinition(task);
        String user = Optional.ofNullable(task.getAssignee()).map(arg_0 -> ((UserService)this.userService).getUserString(arg_0)).orElse("");
        TaskInfo taskInfo = new TaskInfo(task.getId(), (String)ProcessTaskConstants.TASK_DESCRIPTION_VARIABLE.from((VariableScope)task).getOrDefault((Object)((String)ProcessTaskConstants.TASK_DESCRIPTION_DIGITALWF_VARIABLE.from((VariableScope)task).getOrDefault((Object)""))), definition.getName(), user, task.getProcessInstanceId());
        this.save(taskInfo);
    }

    public void updateTaskInfo(String taskId, TaskInfoUpdate update) {
        TaskInfo model = this.findByTaskId(taskId);
        String user = Optional.ofNullable(update.getAssignee()).map(arg_0 -> ((UserService)this.userService).getUserString(arg_0)).orElse("");
        model.updateAssignee(user);
        this.save(model);
    }

    public void deleteTaskInfo(String taskId) {
        this.taskInfoRepository.deleteById((Object)taskId);
    }

    private void save(TaskInfo taskInfo) {
        TaskInfoEntity entity = this.taskInfoMapper.map2Entity(taskInfo);
        this.taskInfoRepository.save((Object)entity);
    }

    private ProcessDefinition getProcessDefinition(DelegateTask task) {
        return this.serviceDefinitionService.getServiceDefinition(task.getProcessDefinitionId());
    }

    public TaskInfoService(TaskInfoRepository taskInfoRepository, TaskInfoMapper taskInfoMapper, ServiceDefinitionService serviceDefinitionService, UserService userService) {
        this.taskInfoRepository = taskInfoRepository;
        this.taskInfoMapper = taskInfoMapper;
        this.serviceDefinitionService = serviceDefinitionService;
        this.userService = userService;
    }
}

