/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.infrastructure.repository;

import io.muenchendigital.digiwf.humantask.infrastructure.entity.TaskInfoEntity;
import io.muenchendigital.digiwf.humantask.infrastructure.entity.camunda.ActRuTaskEntity;
import io.muenchendigital.digiwf.humantask.infrastructure.repository.ActRuTaskCriteriaProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class ActRuTaskSearchRepository
extends ActRuTaskCriteriaProvider {
    private final EntityManager em;

    public Page<ActRuTaskEntity> search(String assigneeId, String searchQuery, Boolean followUp, Pageable pageable) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery resultQuery = cb.createQuery(ActRuTaskEntity.class);
        Root actRuTask = resultQuery.from(ActRuTaskEntity.class);
        Join taskInfo = actRuTask.join("taskInfoEntity");
        Predicate[] predicates = this.getPredicates(assigneeId, searchQuery, followUp, cb, actRuTask, taskInfo);
        List orders = this.getOrderList(pageable, cb, actRuTask);
        resultQuery.where(predicates).orderBy(orders);
        List result = this.em.createQuery(resultQuery).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).getResultList();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root actRuTaskCount = countQuery.from(ActRuTaskEntity.class);
        actRuTaskCount.join("taskInfoEntity");
        countQuery.select((Selection)cb.count((Expression)actRuTaskCount)).where(predicates);
        Long count = (Long)this.em.createQuery(countQuery).getSingleResult();
        return new PageImpl(result, pageable, count.longValue());
    }

    private Predicate[] getPredicates(String assigneeId, @Nullable String searchQuery, Boolean isFollowUp, CriteriaBuilder cb, Root<ActRuTaskEntity> actRuTask, Join<ActRuTaskEntity, TaskInfoEntity> taskInfo) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Predicate assigneeIdPredicate = cb.equal((Expression)actRuTask.get("assignee"), (Object)assigneeId);
        predicates.add(assigneeIdPredicate);
        if (searchQuery != null && !searchQuery.isBlank()) {
            predicates.add(this.getSearchQueryPredicates(searchQuery, cb, actRuTask, taskInfo));
        }
        if (isFollowUp.booleanValue()) {
            predicates.add(this.getFollowUpPredicate(cb, actRuTask));
        }
        return predicates.toArray(new Predicate[0]);
    }

    private Predicate getFollowUpPredicate(CriteriaBuilder cb, Root<ActRuTaskEntity> actRuTask) {
        Date today = new Date();
        return cb.or((Expression)cb.isNull((Expression)actRuTask.get("followUpDate")), (Expression)cb.lessThanOrEqualTo((Expression)actRuTask.get("followUpDate"), (Comparable)today));
    }

    public ActRuTaskSearchRepository(EntityManager em) {
        this.em = em;
    }
}

