/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.humantask.process.listener;

import io.muenchendigital.digiwf.process.instance.process.properties.S3Properties;
import java.util.Map;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class S3VariableTaskCreateListener {
    private final TaskService taskService;
    private final S3Properties s3Properties;

    @EventListener(condition="#task.eventName.equals('create')")
    public void delegateTask(DelegateTask task) {
        Map taskVariables = task.getVariables();
        String s3Topic = taskVariables.containsKey("app_file_s3_async_config") ? (String)taskVariables.get("app_file_s3_async_config") : this.s3Properties.getTopic();
        String s3HttpApi = taskVariables.containsKey("app_file_s3_sync_config") ? (String)taskVariables.get("app_file_s3_sync_config") : this.s3Properties.getHttpAPI();
        this.taskService.setVariable(task.getId(), "app_file_s3_async_config", (Object)s3Topic);
        this.taskService.setVariable(task.getId(), "app_file_s3_sync_config", (Object)s3HttpApi);
    }

    public S3VariableTaskCreateListener(TaskService taskService, S3Properties s3Properties) {
        this.taskService = taskService;
        this.s3Properties = s3Properties;
    }
}

