/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.info.api.resource;

import io.muenchendigital.digiwf.info.api.mapper.InfoTOMapper;
import io.muenchendigital.digiwf.info.api.transport.InfoTO;
import io.muenchendigital.digiwf.info.domain.model.Info;
import io.muenchendigital.digiwf.info.domain.service.InfoService;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@Transactional
@RequestMapping(value={"/rest/info"})
@Tag(name="InfoRestController", description="API to handle app infos")
public class InfoRestController {
    private final InfoService infoService;
    private final InfoTOMapper infoMapper;

    @GetMapping
    public ResponseEntity<InfoTO> getInfo() {
        Info info = this.infoService.getInfo();
        return ResponseEntity.ok((Object)((InfoTO)this.infoMapper.map2TO((Object)info)));
    }

    public InfoRestController(InfoService infoService, InfoTOMapper infoMapper) {
        this.infoService = infoService;
        this.infoMapper = infoMapper;
    }
}

