/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.jsonschema.api.resource;

import io.muenchendigital.digiwf.jsonschema.api.mapper.SchemaApiMapper;
import io.muenchendigital.digiwf.jsonschema.api.transport.JsonSchemaTO;
import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import io.muenchendigital.digiwf.jsonschema.domain.service.JsonSchemaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@Transactional
@RestController
@RequestMapping(value={"/rest/jsonschema"})
@Tag(name="SchemaRestController", description="API to handle json schemas")
public class JsonSchemaRestController {
    private final JsonSchemaService schemaService;
    private final SchemaApiMapper schemaApiMapper;

    @PostMapping
    @Operation(description="create a new json schema")
    @PreAuthorize(value="hasAuthority(T(io.muenchendigital.digiwf.shared.security.AuthoritiesEnum).BACKEND_DEPLOY_RESOURCE.name())")
    public ResponseEntity<JsonSchemaTO> createJsonSchema(@RequestBody @Valid JsonSchemaTO to) {
        JsonSchema jsonSchema = this.schemaApiMapper.map2Model(to);
        return ResponseEntity.ok((Object)this.schemaApiMapper.map2TO(this.schemaService.createJsonSchema(jsonSchema)));
    }

    @GetMapping(value={"/{key}"})
    @Operation(description="get json schema by key")
    public ResponseEntity<JsonSchemaTO> getJsonSchema(@PathVariable String key) {
        return this.schemaService.getByKey(key).map(jsonSchema -> ResponseEntity.ok((Object)this.schemaApiMapper.map2TO(jsonSchema))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    public JsonSchemaRestController(JsonSchemaService schemaService, SchemaApiMapper schemaApiMapper) {
        this.schemaService = schemaService;
        this.schemaApiMapper = schemaApiMapper;
    }
}

