/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.jsonschema.deployment.api.streaming;

import io.muenchendigital.digiwf.asyncapi.docs.annotations.DocumentAsyncAPI;
import io.muenchendigital.digiwf.deployment.domain.model.DeploymentStatusModel;
import io.muenchendigital.digiwf.jsonschema.deployment.api.mapper.SchemaDeploymentMapper;
import io.muenchendigital.digiwf.jsonschema.deployment.api.streaming.event.SchemaDeploymentEvent;
import io.muenchendigital.digiwf.jsonschema.deployment.domain.service.SchemaDeploymentService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Sinks;

@Component
public class SchemaDeploymentEventListener {
    private static final Logger log = LoggerFactory.getLogger(SchemaDeploymentEventListener.class);
    private final Sinks.Many<Message<DeploymentStatusModel>> statusEmitter;
    private final SchemaDeploymentService modelDeploymentService;
    private final SchemaDeploymentMapper mapper;

    @DocumentAsyncAPI(payload=SchemaDeploymentEvent.class, functionRouter=true, typeHeader="deploySchema")
    @Bean
    public Consumer<Message<SchemaDeploymentEvent>> deploySchema() {
        return message -> {
            SchemaDeploymentEvent deploymentEvent = (SchemaDeploymentEvent)message.getPayload();
            log.info("Sent deployment event with deploymentId: {}, versionId: {}, target: {}, artifactType: {}", new Object[]{deploymentEvent.getDeploymentId(), deploymentEvent.getVersionId(), deploymentEvent.getTarget(), deploymentEvent.getArtifactType()});
            DeploymentStatusModel status = this.modelDeploymentService.deploy(this.mapper.mapTo(deploymentEvent));
            Message statusMessage = MessageBuilder.withPayload((Object)status).build();
            this.statusEmitter.tryEmitNext((Object)statusMessage).orThrow();
            log.info("Sent deployment status event for deployment {}", (Object)status.getDeploymentId());
        };
    }

    public SchemaDeploymentEventListener(Sinks.Many<Message<DeploymentStatusModel>> statusEmitter, SchemaDeploymentService modelDeploymentService, SchemaDeploymentMapper mapper) {
        this.statusEmitter = statusEmitter;
        this.modelDeploymentService = modelDeploymentService;
        this.mapper = mapper;
    }
}

