/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.jsonschema.domain.model;

import io.muenchendigital.digiwf.json.factory.JsonSchemaFactory;
import io.muenchendigital.digiwf.jsonschema.domain.model.JsonSchema;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity(name="JsonSchema")
@Table(name="DWF_JSON_SCHEMA", indexes={@Index(name="IDX_DWF_SCHEMAKEY", columnList="key_")})
public class JsonSchema {
    @Id
    @Column(name="key_")
    private String key;
    @Column(name="schema_", columnDefinition="CLOB")
    private String schema;

    public Map<String, Object> getSchemaMap() {
        return (Map)JsonSchemaFactory.gson().fromJson(this.schema, JsonSchemaFactory.mapType());
    }

    public static JsonSchemaBuilder builder() {
        return new JsonSchemaBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String toString() {
        return "JsonSchema(key=" + this.getKey() + ", schema=" + this.getSchema() + ")";
    }

    public JsonSchema() {
    }

    public JsonSchema(String key, String schema) {
        this.key = key;
        this.schema = schema;
    }
}

