/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.alw.external;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.muenchendigital.digiwf.legacy.alw.properties.AlwProperties;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class PersonenInfoClient {
    private static final Logger log = LoggerFactory.getLogger(PersonenInfoClient.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final AlwProperties properties;

    public String getResponsibleLdapGroup(String azr) throws JsonProcessingException {
        String restCallFullUrl = this.properties.getEaiUrl() + "camel/foreigners/azr/" + azr + "/responsible-ldap-group";
        log.info("calling getResponsibleLdapGroup: {}", (Object)restCallFullUrl);
        String resultJSON = (String)this.restTemplate.getForObject(restCallFullUrl, String.class, new Object[0]);
        HashMap resultMAP = (HashMap)new ObjectMapper().readValue(resultJSON, HashMap.class);
        return Optional.ofNullable(resultMAP.get("group")).map(Object::toString).orElse(null);
    }

    public PersonenInfoClient(AlwProperties properties) {
        this.properties = properties;
    }
}

