/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.alw.process;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.alw.domain.AlwService;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlwPersonenInfoDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(AlwPersonenInfoDelegate.class);
    private final AlwService kvrService;
    public static final VariableFactory<String> AZR_NUMMER = CamundaBpmData.stringVariable((String)"kvr_azr_nummer");
    public static final VariableFactory<String> RESPONSIBLE_GROUP = CamundaBpmData.stringVariable((String)"kvr_responsible_group");

    public void execute(DelegateExecution execution) throws Exception {
        Optional azrNummer = AZR_NUMMER.from((VariableScope)execution).getLocalOptional();
        if (!azrNummer.isPresent()) {
            RESPONSIBLE_GROUP.on((VariableScope)execution).setLocal(null);
            return;
        }
        try {
            String responsibleGroup = this.kvrService.getResponsibleLdapGroup((String)azrNummer.get());
            RESPONSIBLE_GROUP.on((VariableScope)execution).setLocal((Object)responsibleGroup);
        }
        catch (Exception error) {
            log.error("Personeninfo could no be loaded AZRNummer: " + azrNummer, (Throwable)error);
            RESPONSIBLE_GROUP.on((VariableScope)execution).setLocal(null);
        }
    }

    public AlwPersonenInfoDelegate(AlwService kvrService) {
        this.kvrService = kvrService;
    }
}

