/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.alwdms.domain.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.model.AlwMetadata;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.model.AlwSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.alwdms.external.client.AlwDmsClient;
import io.muenchendigital.digiwf.legacy.dms.alwdms.properties.AlwDmsProperties;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpServerErrorException;

@Service
public class AlwDmsService {
    private static final Logger log = LoggerFactory.getLogger(AlwDmsService.class);
    private final AlwDmsClient client;
    private final UserService userService;
    private final AlwDmsProperties properties;

    public AlwMetadata getContentMetadata(String user, String url) {
        String username = this.getUsername(user);
        try {
            AlwMetadata metadata = this.client.readContentMetaData(username, this.parseUrl(url));
            metadata.setUrl(url);
            return metadata;
        }
        catch (JsonProcessingException e) {
            throw new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Metadata could no be read. User: %s Obj: %s", user, url));
        }
    }

    public AlwSchriftstueck readSchriftstueck(String user, String url) {
        String username = this.getUsername(user);
        try {
            return this.client.readSchriftstueck(username, this.parseUrl(url));
        }
        catch (JsonProcessingException e) {
            throw new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Schriftstueck could no be read. User: %s Obj: %s", user, url));
        }
    }

    private String getUsername(String user) {
        String defaultUser = this.properties.getDefaultUser();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{defaultUser})) {
            return this.userService.getUser(defaultUser).getUsername();
        }
        return this.userService.getUser(user).getUsername();
    }

    private String parseUrl(String url) {
        return url.substring(url.lastIndexOf("/mx/") + 4);
    }

    public AlwDmsService(AlwDmsClient client, UserService userService, AlwDmsProperties properties) {
        this.client = client;
        this.userService = userService;
        this.properties = properties;
    }
}

