/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.alwdms.external.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.model.AlwMetadata;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.model.AlwSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.alwdms.external.mapper.ReadMetadataTOMapper;
import io.muenchendigital.digiwf.legacy.dms.alwdms.external.mapper.ReadSchrifstueckTOMapper;
import io.muenchendigital.digiwf.legacy.dms.alwdms.external.transport.ReadMetadataTO;
import io.muenchendigital.digiwf.legacy.dms.alwdms.external.transport.ReadSchriftstueckTO;
import io.muenchendigital.digiwf.legacy.dms.alwdms.properties.AlwDmsProperties;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AlwDmsClient {
    private static final Logger log = LoggerFactory.getLogger(AlwDmsClient.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final AlwDmsProperties properties;
    private final ReadSchrifstueckTOMapper readSchrifstueckMapper;
    private final ReadMetadataTOMapper readMetadataMapper;

    public AlwSchriftstueck readSchriftstueck(@NotBlank String username, @NotBlank String schriftstueckCOO) throws JsonProcessingException {
        String restCallFullUrl = this.properties.getEaiUrl() + "camel/schriftstueck?login=" + username + "&schriftstueckCOO=" + schriftstueckCOO;
        log.info("calling readSchriftstueck: {}", (Object)schriftstueckCOO);
        String resultJSON = (String)this.restTemplate.getForObject(restCallFullUrl, String.class, new Object[0]);
        ReadSchriftstueckTO schritstueck = (ReadSchriftstueckTO)new ObjectMapper().readValue(resultJSON, ReadSchriftstueckTO.class);
        return this.readSchrifstueckMapper.map(schritstueck);
    }

    public AlwMetadata readContentMetaData(@NotBlank String userLogin, @NotBlank String objCOO) throws JsonProcessingException {
        String restCallFullUrl = this.properties.getEaiUrl() + "camel/metadata?login=" + userLogin + "&objCOO=" + objCOO;
        log.info("calling readContentMetaData: {}", (Object)objCOO);
        String resultJSON = (String)this.restTemplate.getForObject(restCallFullUrl, String.class, new Object[0]);
        ReadMetadataTO metadata = (ReadMetadataTO)new ObjectMapper().readValue(resultJSON, ReadMetadataTO.class);
        return (AlwMetadata)this.readMetadataMapper.map((Object)metadata);
    }

    public AlwDmsClient(AlwDmsProperties properties, ReadSchrifstueckTOMapper readSchrifstueckMapper, ReadMetadataTOMapper readMetadataMapper) {
        this.properties = properties;
        this.readSchrifstueckMapper = readSchrifstueckMapper;
        this.readMetadataMapper = readMetadataMapper;
    }
}

