/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.api.resource;

import io.muenchendigital.digiwf.legacy.dms.muc.api.mapper.MetadataTOMapper;
import io.muenchendigital.digiwf.legacy.dms.muc.api.transport.GetMetadataTO;
import io.muenchendigital.digiwf.legacy.dms.muc.api.transport.MetadataTO;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Metadata;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.shared.security.AppAuthenticationProvider;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@Transactional
@RequestMapping(value={"/rest/dms"})
@Tag(name="DmsRestController", description="API to interact with the mucs-dms")
public class DmsRestController {
    private final DmsService dmsService;
    private final MetadataTOMapper metaDataMapper;
    private final AppAuthenticationProvider authenticationProvider;

    @PostMapping(value={"/metadata"})
    public ResponseEntity<MetadataTO> getMetaData(@RequestBody @Valid GetMetadataTO request) {
        String userLogin = this.authenticationProvider.getCurrentUserId();
        Metadata dmetaData = this.dmsService.getMetadata(userLogin, request.getUrl());
        return ResponseEntity.ok((Object)((MetadataTO)this.metaDataMapper.map2TO((Object)dmetaData)));
    }

    public DmsRestController(DmsService dmsService, MetadataTOMapper metaDataMapper, AppAuthenticationProvider authenticationProvider) {
        this.dmsService = dmsService;
        this.metaDataMapper = metaDataMapper;
        this.authenticationProvider = authenticationProvider;
    }
}

