/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.createdokument;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Dokument;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuesSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Schriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.shared.S3Resolver;
import io.muenchendigital.digiwf.legacy.document.domain.DocumentService;
import java.util.Collections;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.springframework.stereotype.Component;

@Component
public class CreateDokumentDelegate
implements JavaDelegate {
    private final DmsService dmsService;
    private final DocumentService documentService;
    private final S3Resolver s3Resolver;
    public static final VariableFactory<String> PROZESS_ID = CamundaBpmData.stringVariable((String)"dms_prozess_id");
    public static final VariableFactory<String> COSYS_GUID = CamundaBpmData.stringVariable((String)"dms_cosys_guid");
    public static final VariableFactory<String> S3_URL = CamundaBpmData.stringVariable((String)"dms_s3_url");
    public static final VariableFactory<String> VORGANG_COO = CamundaBpmData.stringVariable((String)"dms_vorgang_coo");
    public static final VariableFactory<String> SCHRIFTSTUECK_NAME = CamundaBpmData.stringVariable((String)"dms_schriftstueck_name");
    public static final VariableFactory<String> USER_LOGIN = CamundaBpmData.stringVariable((String)"dms_user_login");
    public static final VariableFactory<String> SCHRIFTSTUECK = CamundaBpmData.stringVariable((String)"dms_created_schriftstueck");

    public void execute(DelegateExecution execution) throws Exception {
        byte[] documentContent;
        String prozessId = (String)PROZESS_ID.from((VariableScope)execution).getLocal();
        Optional cosysGuid = COSYS_GUID.from((VariableScope)execution).getLocalOptional();
        String vorgangCOO = (String)VORGANG_COO.from((VariableScope)execution).getLocal();
        String schriftstueckName = (String)SCHRIFTSTUECK_NAME.from((VariableScope)execution).getLocal();
        String userLogin = (String)USER_LOGIN.from((VariableScope)execution).getLocal();
        Optional s3Url = S3_URL.from((VariableScope)execution).getLocalOptional();
        if (cosysGuid.isPresent() && !((String)cosysGuid.get()).isBlank()) {
            documentContent = this.documentService.createDocument((String)cosysGuid.get(), prozessId);
        } else if (s3Url.isPresent()) {
            documentContent = this.s3Resolver.getS3File((String)s3Url.get());
        } else {
            throw new IllegalArgumentException("no document provided");
        }
        NeuesSchriftstueck schriftstueck = NeuesSchriftstueck.builder().content(documentContent).extension("pdf").name(schriftstueckName).build();
        Dokument document = this.dmsService.createDokument(schriftstueckName, vorgangCOO, userLogin, Collections.singletonList(schriftstueck));
        Schriftstueck savedSchriftstueck = (Schriftstueck)document.getSchriftstuecke().get(0);
        SCHRIFTSTUECK.on((VariableScope)execution).setLocal((Object)savedSchriftstueck.getCoo());
    }

    public CreateDokumentDelegate(DmsService dmsService, DocumentService documentService, S3Resolver s3Resolver) {
        this.dmsService = dmsService;
        this.documentService = documentService;
        this.s3Resolver = s3Resolver;
    }
}

