/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.createsachakte;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Sachakte;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSException;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSStatusCode;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CreateSachakteDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(CreateSachakteDelegate.class);
    private final DmsService dmsService;
    public static final VariableFactory<String> SACHAKTE_NAME = CamundaBpmData.stringVariable((String)"dms_sachakte_name");
    public static final VariableFactory<String> AKTENPLAN_NAME = CamundaBpmData.stringVariable((String)"dms_aktenplan_name");
    public static final VariableFactory<String> USER_LOGIN = CamundaBpmData.stringVariable((String)"dms_user_login");
    public static final VariableFactory<String> SACHAKTE_COO = CamundaBpmData.stringVariable((String)"dms_sachakte_coo");

    public void execute(DelegateExecution execution) throws Exception {
        String sackakteName = (String)SACHAKTE_NAME.from((VariableScope)execution).getLocal();
        String aktenplanName = (String)AKTENPLAN_NAME.from((VariableScope)execution).getLocal();
        String userLogin = (String)USER_LOGIN.from((VariableScope)execution).getLocal();
        try {
            Sachakte akte = this.dmsService.createSachakte(sackakteName, aktenplanName, userLogin);
            SACHAKTE_COO.on((VariableScope)execution).setLocal((Object)akte.getCoo());
        }
        catch (DMSException ex) {
            log.error("Could not create sachakte: {}", (Object)ex.getMessage());
            if (DMSStatusCode.OBJEKT_GESPERRT.equals((Object)ex.getStatusCode()) || DMSStatusCode.FEHLENDE_BERECHTIGUNG.equals((Object)ex.getStatusCode()) || DMSStatusCode.MEHR_ALS_1000_UNTERGEORDNETE_OBJEKTE.equals((Object)ex.getStatusCode())) {
                throw new BpmnError(ex.getStatusCode().name(), ex.getMessage());
            }
            throw ex;
        }
    }

    public CreateSachakteDelegate(DmsService dmsService) {
        this.dmsService = dmsService;
    }
}

