/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.muc.process.depositvorgang;

import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSException;
import io.muenchendigital.digiwf.legacy.dms.muc.external.transport.DMSStatusCode;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DepositVorgangDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(DepositVorgangDelegate.class);
    public static final String ERROR_DEPOSIT_FAILED = "AKTENABLAGE_FEHLGESCHLAGEN";
    private final DmsService dmsClient;
    public static final VariableFactory<String> VORGANG_COO = CamundaBpmData.stringVariable((String)"dms_vorgang_coo");
    public static final VariableFactory<String> USER_LOGIN = CamundaBpmData.stringVariable((String)"dms_user_login");

    public void execute(DelegateExecution execution) throws Exception {
        String vorgangCoo = (String)VORGANG_COO.from((VariableScope)execution).getLocal();
        String userLogin = (String)USER_LOGIN.from((VariableScope)execution).getLocal();
        try {
            this.dmsClient.depositVorgang(vorgangCoo, userLogin);
        }
        catch (Exception ex) {
            DMSException dmsException;
            log.error("Could not deposit vorgang: {}", (Object)ex.getMessage());
            if (ex instanceof DMSException && (DMSStatusCode.OBJEKT_GESPERRT.equals((Object)(dmsException = (DMSException)((Object)ex)).getStatusCode()) || DMSStatusCode.FEHLENDE_BERECHTIGUNG.equals((Object)dmsException.getStatusCode()) || DMSStatusCode.UNGUELTIGE_ADRESSE.equals((Object)dmsException.getStatusCode()))) {
                throw new BpmnError(dmsException.getStatusCode().name(), ex.getMessage());
            }
            throw new BpmnError(ERROR_DEPOSIT_FAILED);
        }
    }

    public DepositVorgangDelegate(DmsService dmsClient) {
        this.dmsClient = dmsClient;
    }
}

