/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.dms.process;

import com.google.gson.Gson;
import io.holunda.camunda.bpm.data.CamundaBpmData;
import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.model.AlwMetadata;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.model.AlwSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.alwdms.domain.service.AlwDmsService;
import io.muenchendigital.digiwf.legacy.dms.alwdms.process.readschriftstuecke.KvrReadSchriftstueckeData;
import io.muenchendigital.digiwf.legacy.dms.alwdms.process.readschriftstuecke.KvrReadSchriftstueckeResult;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Dokument;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Metadata;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.NeuesSchriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.model.Schriftstueck;
import io.muenchendigital.digiwf.legacy.dms.muc.domain.service.DmsService;
import io.muenchendigital.digiwf.legacy.dms.muc.process.saveschriftstuecke.SaveSchriftstueckeResult;
import io.muenchendigital.digiwf.legacy.dms.shared.BaseSchriftstueck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class CopySchriftstueckeAlwToMucDelegate
implements JavaDelegate {
    private static final Logger log = LoggerFactory.getLogger(CopySchriftstueckeAlwToMucDelegate.class);
    private final AlwDmsService alwDmsService;
    private final DmsService dmsService;
    public static final VariableFactory<byte[]> SCHRIFTSTUECKE = CamundaBpmData.customVariable((String)"dms_schriftstuecke", byte[].class);
    public static final VariableFactory<String> USER_LOGIN_ALW = CamundaBpmData.stringVariable((String)"dms_user_login_alw");
    public static final VariableFactory<String> USER_LOGIN_MUC = CamundaBpmData.stringVariable((String)"dms_user_login_muc");
    public static final VariableFactory<String> DOCUMENT_NAME = CamundaBpmData.stringVariable((String)"dms_document_name");
    public static final VariableFactory<String> VORGANG_COO = CamundaBpmData.stringVariable((String)"dms_vorgang_coo");
    public static final VariableFactory<String> DOCUMENT_COO = CamundaBpmData.stringVariable((String)"dms_document_coo");
    public static final VariableFactory<SaveSchriftstueckeResult[]> SAVE_SCHRIFTSTUECKE_RESULT = CamundaBpmData.customVariable((String)"dms_save_schriftstuecke_result", SaveSchriftstueckeResult[].class);

    public void execute(DelegateExecution execution) throws Exception {
        KvrReadSchriftstueckeData[] data = (KvrReadSchriftstueckeData[])new Gson().fromJson(new String((byte[])SCHRIFTSTUECKE.from((VariableScope)execution).getLocal()), KvrReadSchriftstueckeData[].class);
        String alwUser = (String)USER_LOGIN_ALW.from((VariableScope)execution).getLocal();
        String userMuc = (String)USER_LOGIN_MUC.from((VariableScope)execution).getLocal();
        String documentName = (String)DOCUMENT_NAME.from((VariableScope)execution).getLocal();
        String vorgangCOO = (String)VORGANG_COO.from((VariableScope)execution).getLocal();
        ArrayList<KvrReadSchriftstueckeResult> readResult = new ArrayList<KvrReadSchriftstueckeResult>();
        for (KvrReadSchriftstueckeData readData : data) {
            ArrayList<AlwSchriftstueck> resultList = new ArrayList<AlwSchriftstueck>();
            for (AlwMetadata schriftstueck : readData.getSchriftstuecke()) {
                try {
                    AlwSchriftstueck schriftstueckModel = this.alwDmsService.readSchriftstueck(alwUser, schriftstueck.getUrl());
                    resultList.add(schriftstueckModel);
                }
                catch (HttpClientErrorException error) {
                    log.error("Document could not be read from dms kvr: {}", (Object)schriftstueck.getUrl(), (Object)error);
                    throw error;
                }
            }
            readResult.add(KvrReadSchriftstueckeResult.builder().fieldKey(readData.getFieldKey()).schriftstuecke((BaseSchriftstueck[])resultList.toArray(new AlwSchriftstueck[0])).build());
        }
        ArrayList<SaveSchriftstueckeResult> resultData = new ArrayList<SaveSchriftstueckeResult>();
        List alleSchriftstuecke = readResult.stream().map(KvrReadSchriftstueckeResult::getSchriftstuecke).flatMap(Stream::of).map(arg_0 -> this.parse(arg_0)).collect(Collectors.toList());
        Dokument document = this.dmsService.createDokument(documentName, vorgangCOO, userMuc);
        for (NeuesSchriftstueck schriftstueck : alleSchriftstuecke) {
            this.dmsService.updateDocument(document, Collections.singletonList(schriftstueck), userMuc);
        }
        List updatedSchriftstuecke = this.dmsService.getAllSchrifstuecke(document.getCoo(), userMuc);
        int counter = 0;
        for (KvrReadSchriftstueckeData schriftstueckeData : data) {
            SaveSchriftstueckeResult result = SaveSchriftstueckeResult.builder().fieldKey(schriftstueckeData.getFieldKey()).schriftstuecke(this.map(updatedSchriftstuecke, schriftstueckeData.getSchriftstuecke().size(), userMuc, counter)).build();
            counter += result.getSchriftstuecke().size();
            resultData.add(result);
        }
        DOCUMENT_COO.on((VariableScope)execution).setLocal((Object)document.getCoo());
        SAVE_SCHRIFTSTUECKE_RESULT.on((VariableScope)execution).setLocal((Object)resultData.toArray(new SaveSchriftstueckeResult[0]));
    }

    private NeuesSchriftstueck parse(BaseSchriftstueck schriftstueck) {
        return NeuesSchriftstueck.builder().content(schriftstueck.getContent()).extension(schriftstueck.getExtension()).name(schriftstueck.getName()).build();
    }

    private List<Metadata> map(List<Schriftstueck> schriftstuecke, int size, String userlogin, int counter) {
        ArrayList<Schriftstueck> fieldDchriftstuecke = new ArrayList<Schriftstueck>();
        for (int i = 0; i < size; ++i) {
            Schriftstueck doc = schriftstuecke.get(counter + i);
            fieldDchriftstuecke.add(doc);
        }
        return this.dmsService.getMetadata(fieldDchriftstuecke, userlogin);
    }

    public CopySchriftstueckeAlwToMucDelegate(AlwDmsService alwDmsService, DmsService dmsService) {
        this.alwDmsService = alwDmsService;
        this.dmsService = dmsService;
    }
}

