/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.form.api.resource;

import io.muenchendigital.digiwf.legacy.form.api.mapper.FormTOMapper;
import io.muenchendigital.digiwf.legacy.form.api.transport.FormTO;
import io.muenchendigital.digiwf.legacy.form.domain.model.Form;
import io.muenchendigital.digiwf.legacy.form.domain.service.FormService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@Transactional
@RequestMapping(value={"/rest/form"})
@Tag(name="FormRestController", description="API to handle forms")
public class FormRestController {
    private final FormService formService;
    private final FormTOMapper formMapper;

    @GetMapping
    public ResponseEntity<List<FormTO>> getForms() {
        List forms = this.formService.getForms();
        return ResponseEntity.ok((Object)this.formMapper.map2TO(forms));
    }

    @PutMapping(value={"/{key}"})
    @PreAuthorize(value="hasAuthority(T(io.muenchendigital.digiwf.shared.security.AuthoritiesEnum).BACKEND_DEPLOY_RESOURCE.name())")
    public ResponseEntity<FormTO> updateForm(@PathVariable(value="key") @NotBlank String formKey, @RequestBody @Valid FormTO to) {
        if (this.formService.getForm(formKey).isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return this.createForm(to);
    }

    @PostMapping
    @PreAuthorize(value="hasAuthority(T(io.muenchendigital.digiwf.shared.security.AuthoritiesEnum).BACKEND_DEPLOY_RESOURCE.name())")
    public ResponseEntity<FormTO> createForm(@RequestBody @Valid FormTO to) {
        Form form = (Form)this.formMapper.map((Object)to);
        Form savedForm = this.formService.saveForm(form);
        FormTO savedTO = (FormTO)this.formMapper.map2TO((Object)savedForm);
        return ResponseEntity.ok((Object)savedTO);
    }

    @GetMapping(value={"/{key}"})
    public ResponseEntity<FormTO> getForm(@PathVariable(value="key") @NotBlank String formKey) {
        Form form = (Form)this.formService.getForm(formKey).orElseThrow();
        FormTO to = (FormTO)this.formMapper.map2TO((Object)form);
        return ResponseEntity.ok((Object)to);
    }

    public FormRestController(FormService formService, FormTOMapper formMapper) {
        this.formService = formService;
        this.formMapper = formMapper;
    }
}

