/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.form.configuration;

import com.google.gson.Gson;
import io.muenchendigital.digiwf.legacy.form.api.mapper.FormTOMapper;
import io.muenchendigital.digiwf.legacy.form.api.transport.FormTO;
import io.muenchendigital.digiwf.legacy.form.domain.model.Form;
import io.muenchendigital.digiwf.legacy.form.domain.service.FormService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;

@Component
@ConditionalOnProperty(value={"digiwf.form.autodeploy"})
public class FormAutodeploymentHandler {
    private static final Logger log = LoggerFactory.getLogger(FormAutodeploymentHandler.class);
    protected final ResourceLoader resourceLoader;
    private final FormTOMapper formMapper;
    private final FormService formService;

    @PostConstruct
    public void autoDeployForms() throws IOException {
        Resource[] resources = this.getResources();
        ArrayList<Form> forms = new ArrayList<Form>();
        for (Resource resource : resources) {
            try {
                Form map = this.map(resource);
                forms.add(map);
            }
            catch (Exception error) {
                log.error("Could not load form: {}", (Object)resource.getFilename(), (Object)error);
            }
        }
        for (Form form : forms) {
            try {
                this.formService.saveForm(form);
            }
            catch (Exception error) {
                log.error("Could not deploy form: {}", (Object)form.getKey(), (Object)error);
            }
        }
    }

    public Resource[] getResources() throws IOException {
        return ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.resourceLoader).getResources("classpath:prozesse/**/*.form.json");
    }

    private Form map(Resource resource) throws IOException {
        String formJson = this.asString(resource);
        FormTO to = (FormTO)new Gson().fromJson(formJson, FormTO.class);
        return (Form)this.formMapper.map((Object)to);
    }

    private String asString(Resource resource) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
    }

    public FormAutodeploymentHandler(ResourceLoader resourceLoader, FormTOMapper formMapper, FormService formService) {
        this.resourceLoader = resourceLoader;
        this.formMapper = formMapper;
        this.formService = formService;
    }
}

