/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.form.domain.validator;

import io.muenchendigital.digiwf.legacy.form.domain.model.FieldTypes;
import io.muenchendigital.digiwf.legacy.form.domain.model.FormField;
import io.muenchendigital.digiwf.legacy.form.domain.validator.ValidationHandler;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LdapValidationHandler
implements ValidationHandler {
    private final UserService userService;

    public String getType() {
        return FieldTypes.LDAP_INPUT;
    }

    public boolean validate(Object value, FormField field) {
        if (!this.getType().equals(field.getType())) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)((String)value))) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)field.getLdapOus())) {
            return true;
        }
        List groups = this.userService.getGroups(value.toString());
        String[] ous = field.getLdapOus().toLowerCase().split(",");
        return Arrays.stream(ous).anyMatch(groups::contains);
    }

    public LdapValidationHandler(UserService userService) {
        this.userService = userService;
    }
}

