/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.mailing.domain.service;

import io.muenchendigital.digiwf.legacy.mailing.domain.configuration.MailConfigurationHandler;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.Mail;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.MailTemplate;
import io.muenchendigital.digiwf.legacy.mailing.domain.service.MailTemplateService;
import io.muenchendigital.digiwf.legacy.mailing.properties.MailProperties;
import java.io.IOException;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.stereotype.Service;

@Service
public class MailingService {
    private static final Logger log = LoggerFactory.getLogger(MailingService.class);
    private final JavaMailSender mailSender;
    private final MailProperties properties;
    private final MailConfigurationHandler mailConfigurationHandler;
    private final MailTemplateService mailTemplateService;

    public void sendMail(Mail mail) {
        this.mailConfigurationHandler.handleMail(mail);
        MimeMessagePreparator preparator = mimeMessage -> {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mail.getReceivers()));
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
            helper.setText(mail.getBody());
            helper.setSubject(mail.getSubject());
            helper.setFrom(this.properties.getDefaultFromAddress());
            if (mail.hasReplyTo()) {
                helper.setReplyTo(mail.getReplyTo());
            }
            if (mail.hasAttachement()) {
                ByteArrayDataSource attachment = new ByteArrayDataSource(mail.getAttachment().getContent(), MediaType.APPLICATION_PDF.toString());
                helper.addAttachment(mail.getAttachment().getName(), (DataSource)attachment);
            }
        };
        this.mailSender.send(preparator);
        log.info("mail send to: {})", (Object)mail.getReceivers());
    }

    public void sendMailTemplateWithLink(MailTemplate mail) throws IOException {
        this.mailConfigurationHandler.handleMail(mail);
        String mailTemplate = this.mailTemplateService.getMailTemplateWithLink();
        String text = mailTemplate.replaceAll("%%body_top%%", mail.getBody()).replaceAll("%%body_bottom%%", StringUtils.isBlank((CharSequence)mail.getBottomText()) ? "Mit freundlichen Gr\u00fc\u00dfen<br>Ihr DigiWF-Team" : mail.getBottomText()).replaceAll("%%button_link%%", mail.getLink()).replaceAll("%%button_text%%", mail.getButtonText()).replaceAll("%%footer%%", "DigiWF 2.0<br>IT-Referat der Stadt M\u00fcnchen");
        this.send(mail, text, null);
    }

    public void sendMailTemplate(MailTemplate mail, String logoPath) throws IOException {
        this.mailConfigurationHandler.handleMail(mail);
        String mailTemplate = this.mailTemplateService.getMailTemplate();
        String text = mailTemplate.replaceAll("%%body_top%%", mail.getBody()).replaceAll("%%body_bottom%%", StringUtils.isBlank((CharSequence)mail.getBottomText()) ? "Mit freundlichen Gr\u00fc\u00dfen<br>Ihr DigiWF-Team" : mail.getBottomText()).replaceAll("%%footer%%", "DigiWF 2.0<br>IT-Referat der Stadt M\u00fcnchen");
        this.send(mail, text, logoPath);
    }

    private void send(MailTemplate mail, String text, String logoPath) {
        MimeMessagePreparator preparator = mimeMessage -> {
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mail.getReceivers()));
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setText(text, true);
            helper.setSubject(mail.getSubject());
            helper.setFrom(StringUtils.isBlank((CharSequence)mail.getSender()) ? this.properties.getDefaultFromAddress() : mail.getSender());
            helper.addInline("logo", StringUtils.isBlank((CharSequence)logoPath) ? this.mailTemplateService.getLogo() : this.mailTemplateService.getLogoByPath(logoPath));
            if (mail.hasReplyTo()) {
                helper.setReplyTo(mail.getReplyTo());
            }
            if (mail.hasAttachement()) {
                ByteArrayDataSource attachment = new ByteArrayDataSource(mail.getAttachment().getContent(), MediaType.APPLICATION_PDF.toString());
                helper.addAttachment(mail.getAttachment().getName(), (DataSource)attachment);
            }
        };
        this.mailSender.send(preparator);
    }

    public MailingService(JavaMailSender mailSender, MailProperties properties, MailConfigurationHandler mailConfigurationHandler, MailTemplateService mailTemplateService) {
        this.mailSender = mailSender;
        this.properties = properties;
        this.mailConfigurationHandler = mailConfigurationHandler;
        this.mailTemplateService = mailTemplateService;
    }
}

