/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.mailing.process;

import io.muenchendigital.digiwf.legacy.document.domain.DocumentService;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.Attachment;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.Mail;
import io.muenchendigital.digiwf.legacy.mailing.domain.service.MailingService;
import io.muenchendigital.digiwf.legacy.mailing.process.MailingVariables;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.springframework.stereotype.Component;

@Component
public class SendMailDelegate
implements JavaDelegate {
    protected final MailingService mailingService;
    protected final DocumentService documentService;

    public void execute(DelegateExecution delegateExecution) throws Exception {
        String subject = (String)MailingVariables.SUBJECT.from((VariableScope)delegateExecution).getLocal();
        String receivers = (String)MailingVariables.RECEIVERS.from((VariableScope)delegateExecution).getLocal();
        String body = (String)MailingVariables.BODY.from((VariableScope)delegateExecution).getLocal();
        Optional replyTo = MailingVariables.REPLY_TO.from((VariableScope)delegateExecution).getLocalOptional();
        Optional attachmentGuid = MailingVariables.ATTACHMENT_GUID.from((VariableScope)delegateExecution).getLocalOptional();
        Optional attachmentName = MailingVariables.ATTACHMENT_NAME.from((VariableScope)delegateExecution).getLocalOptional();
        Mail mail = Mail.builder().body(body).subject(subject).receivers(receivers).replyTo((String)replyTo.orElse(null)).build();
        this.addAttachment(delegateExecution, attachmentGuid, attachmentName, mail);
        this.mailingService.sendMail(mail);
    }

    protected void addAttachment(DelegateExecution delegateExecution, Optional<String> attachmentGuid, Optional<String> attachmentName, Mail mail) {
        if (attachmentGuid.isPresent()) {
            byte[] document = this.documentService.createDocument(attachmentGuid.get(), delegateExecution.getProcessInstance().getVariables());
            Attachment attachement = Attachment.builder().content(document).name(attachmentName.orElse("anhang.pdf")).build();
            mail.setAttachment(attachement);
        }
    }

    public SendMailDelegate(MailingService mailingService, DocumentService documentService) {
        this.mailingService = mailingService;
        this.documentService = documentService;
    }
}

