/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.mailing.process;

import io.muenchendigital.digiwf.legacy.document.domain.DocumentService;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.Mail;
import io.muenchendigital.digiwf.legacy.mailing.domain.model.MailTemplate;
import io.muenchendigital.digiwf.legacy.mailing.domain.service.MailingService;
import io.muenchendigital.digiwf.legacy.mailing.process.MailingVariables;
import io.muenchendigital.digiwf.legacy.mailing.process.SendMailDelegate;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.springframework.stereotype.Component;

@Component
public class SendMailTemplateDelegate
extends SendMailDelegate {
    public SendMailTemplateDelegate(MailingService mailingService, DocumentService documentService) {
        super(mailingService, documentService);
    }

    public void execute(DelegateExecution delegateExecution) throws Exception {
        String subject = (String)MailingVariables.SUBJECT.from((VariableScope)delegateExecution).getLocal();
        String receivers = (String)MailingVariables.RECEIVERS.from((VariableScope)delegateExecution).getLocal();
        String body = (String)MailingVariables.BODY.from((VariableScope)delegateExecution).getLocal();
        Optional replyTo = MailingVariables.REPLY_TO.from((VariableScope)delegateExecution).getLocalOptional();
        String bottomText = (String)MailingVariables.BOTTOM_TEXT.from((VariableScope)delegateExecution).getLocal();
        Optional attachmentGuid = MailingVariables.ATTACHMENT_GUID.from((VariableScope)delegateExecution).getLocalOptional();
        Optional attachmentName = MailingVariables.ATTACHMENT_NAME.from((VariableScope)delegateExecution).getLocalOptional();
        Optional templateId = MailingVariables.TEMPLATE_ID.from((VariableScope)delegateExecution).getLocalOptional();
        Optional sender = MailingVariables.SENDER.from((VariableScope)delegateExecution).getLocalOptional();
        MailTemplate mail = ((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)((MailTemplate.MailTemplateBuilder)MailTemplate.builder().body(body.replaceAll("(\r\n|\n\r|\r|\n)", "<br />"))).bottomText(bottomText.replaceAll("(\r\n|\n\r|\r|\n)", "<br />")).subject(subject)).receivers(receivers)).replyTo((String)replyTo.orElse(null))).sender(sender.orElse("")).build();
        this.addAttachment(delegateExecution, attachmentGuid, attachmentName, (Mail)mail);
        this.mailingService.sendMailTemplate(mail, this.getLogoPathByTemplateId(templateId));
    }

    private String getLogoPathByTemplateId(Optional<String> tempalteId) {
        if (!tempalteId.isPresent()) {
            return null;
        }
        if ("euro2020".equals(tempalteId.get())) {
            return "bausteine/mail/euro2020-logo.png";
        }
        return null;
    }
}

