/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.shared.data.serialize;

import io.muenchendigital.digiwf.legacy.form.domain.model.FieldTypes;
import io.muenchendigital.digiwf.legacy.form.domain.model.FormField;
import io.muenchendigital.digiwf.legacy.shared.data.serialize.SerializeHandler;
import io.muenchendigital.digiwf.legacy.user.domain.model.User;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class LdapInputSerializeHandler
implements SerializeHandler {
    private final UserService userService;

    public Boolean isResponsibleFor(FormField formField) {
        return FieldTypes.LDAP_INPUT.equals(formField.getType());
    }

    public Map<String, Object> serialize(String key, Object value, FormField field) {
        HashMap<String, Object> serializedVariables = new HashMap<String, Object>();
        serializedVariables.put(key, value);
        if (StringUtils.isBlank((CharSequence)((String)value))) {
            return serializedVariables;
        }
        User user = this.userService.getUser(value.toString());
        serializedVariables.put(key + "__detail_name", user.getForename() + " " + user.getSurname());
        serializedVariables.put(key + "__detail_email", user.getEmail());
        serializedVariables.put(key + "__detail_ou", user.getOu());
        return serializedVariables;
    }

    public LdapInputSerializeHandler(UserService userService) {
        this.userService = userService;
    }
}

