/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.shared.data.serialize;

import io.muenchendigital.digiwf.legacy.form.domain.model.FieldTypes;
import io.muenchendigital.digiwf.legacy.form.domain.model.FormField;
import io.muenchendigital.digiwf.legacy.form.domain.model.Item;
import io.muenchendigital.digiwf.legacy.shared.data.serialize.SerializeHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SelectSerializeHandler
implements SerializeHandler {
    public Boolean isResponsibleFor(FormField formField) {
        return FieldTypes.SELECT.equals(formField.getType());
    }

    public Map<String, Object> serialize(String key, Object value, FormField field) {
        HashMap<String, Object> serializedVariables = new HashMap<String, Object>();
        serializedVariables.put(key, value);
        if (field.isMultiple()) {
            serializedVariables.putAll(this.serializeMultipleSelectField(key, value, field));
            return serializedVariables;
        }
        if (StringUtils.isBlank((CharSequence)((String)value))) {
            return serializedVariables;
        }
        String item = field.getItems().stream().filter(obj -> obj.getValue().equals(value)).findFirst().map(Item::getName).orElseThrow(() -> new IllegalArgumentException("Value not present in field: " + value));
        serializedVariables.put(key + "__detail_name", item);
        return serializedVariables;
    }

    private Map<String, Object> serializeMultipleSelectField(String key, Object value, FormField field) {
        HashMap<String, Object> complementVariables = new HashMap<String, Object>();
        if (value == null || value instanceof String) {
            return complementVariables;
        }
        List items = (List)value;
        String values = field.getItems().stream().filter(obj -> items.contains(obj.getValue())).map(Item::getName).collect(Collectors.joining(", "));
        complementVariables.put(key + "__detail_name", values);
        return complementVariables;
    }
}

