/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.user.domain.service;

import io.muenchendigital.digiwf.legacy.user.domain.model.User;
import io.muenchendigital.digiwf.legacy.user.domain.service.UserService;
import io.muenchendigital.digiwf.legacy.user.infrastructure.UserRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"!no-ldap"})
@Service
public class LdapUserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(LdapUserServiceImpl.class);
    private final UserRepository userRepository;

    public List<String> getGroups(String userId) {
        return this.userRepository.findOuTree(userId).stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    public List<User> searchUser(String searchString, String ous) {
        log.debug("Searching user with {}", (Object)searchString);
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            throw new IllegalArgumentException("Expected value in request: queryString");
        }
        List oufilterList = ous == null ? Collections.emptyList() : Arrays.asList(ous.split(","));
        String[] queryStrings = searchString.strip().split(" ");
        ArrayList<User> userInfos = new ArrayList<User>();
        if (queryStrings.length >= 2 && !StringUtils.isEmpty((CharSequence)queryStrings[0]) && !StringUtils.isEmpty((CharSequence)queryStrings[1])) {
            List userInfosByName = this.userRepository.findByNamesLike(queryStrings[0].strip(), queryStrings[1].strip(), oufilterList);
            userInfos.addAll(userInfosByName);
        } else {
            List userInfosByName = this.userRepository.findByNamesLike(searchString.strip(), oufilterList);
            userInfos.addAll(userInfosByName);
        }
        log.debug("Hits for {}: {}", (Object)searchString, (Object)userInfos.size());
        return userInfos;
    }

    public String getUserString(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        Optional user = this.getUserOrNull(userId);
        return user.map(value -> value.getForename() + " " + value.getSurname() + " (" + value.getOu() + ")").orElse(userId);
    }

    public User getUser(String userId) {
        return (User)this.userRepository.findById(userId).orElseThrow(() -> new IllegalArgumentException(String.format("User with the id %s does not exist.", userId)));
    }

    public Optional<User> getUserOrNull(String userId) {
        return this.userRepository.findById(userId);
    }

    public Optional<User> getUserByUserName(String username) {
        return this.userRepository.findByUsername(username);
    }

    public Optional<User> getOuByShortName(String shortname) {
        return this.userRepository.findOuByShortName(shortname);
    }

    public LdapUserServiceImpl(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

