/*
 * Decompiled with CFR 0.152.
 */
package io.muenchendigital.digiwf.legacy.user.external.client;

import io.muenchendigital.digiwf.legacy.user.domain.model.User;
import io.muenchendigital.digiwf.legacy.user.external.client.query.LdapQueryFactory;
import io.muenchendigital.digiwf.legacy.user.external.mapper.UserAttributesMapper;
import io.muenchendigital.digiwf.legacy.user.infrastructure.UserRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQuery;

public class LhmLdapClient
extends LdapTemplate
implements UserRepository {
    private static final Logger log = LoggerFactory.getLogger(LhmLdapClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(LhmLdapClient.class);
    public static final String CACHE_USERS = "ldapusers";
    public static final String CACHE_USERBYNAME = "ldapuserbyname";
    public static final String CACHE_OUTREE = "ldapoutree";
    public static final String CACHE_OUS = "ldapous";
    private static final String LDAP_TYPE_OU = "ou";
    private final LdapQueryFactory ldapQueryFactory;

    public LhmLdapClient(ContextSource contextSource, LdapQueryFactory ldapQueryFactory) {
        super(contextSource);
        this.ldapQueryFactory = ldapQueryFactory;
    }

    @Cacheable(value={"ldapusers"})
    public Optional<User> findById(String id) {
        LOG.debug("Get LDAP information for user {}.", (Object)id);
        LdapQuery query = this.ldapQueryFactory.createPersonByIdQuery(id);
        List userList = super.search(query, (AttributesMapper)new UserAttributesMapper());
        if (userList.size() == 1) {
            return Optional.ofNullable((User)userList.get(0));
        }
        if (userList.isEmpty()) {
            LOG.warn("No user with lhmObjId {} in LDAP found.", (Object)id);
            return Optional.empty();
        }
        LOG.warn("More than one user with lhmObjId {} in LDAP found.", (Object)id);
        return Optional.empty();
    }

    @Cacheable(value={"ldapuserbyname"})
    public Optional<User> findByUsername(String username) {
        LOG.debug("Get LDAP information for user {}.", (Object)username);
        LdapQuery query = this.ldapQueryFactory.createPersonByUsernameQuery(username);
        List userList = super.search(query, (AttributesMapper)new UserAttributesMapper());
        if (userList.size() == 1) {
            return Optional.ofNullable((User)userList.get(0));
        }
        if (userList.isEmpty()) {
            LOG.warn("No user with username {} in LDAP found.", (Object)username);
            return Optional.empty();
        }
        LOG.warn("More than one user with username {} in LDAP found.", (Object)username);
        return Optional.empty();
    }

    @Cacheable(value={"ldapusers"})
    public List<User> findByNamesLike(String expression, List<String> ouFilters) {
        LOG.debug("Get LDAP information for name expression {}.", (Object)expression);
        LdapQuery query = this.ldapQueryFactory.createPersonByNamePatternAndOuQuery(expression, ouFilters);
        return super.search(query, (AttributesMapper)new UserAttributesMapper());
    }

    @Cacheable(value={"ldapusers"})
    public List<User> findByNamesLike(String firstExpression, String secondExpression, List<String> ouFilters) {
        LOG.debug("Get LDAP information for users with {} {}.", (Object)firstExpression, (Object)secondExpression);
        LdapQuery query = this.ldapQueryFactory.createPersonByNamePatternsAndOuQuery(firstExpression, secondExpression, ouFilters);
        return super.search(query, (AttributesMapper)new UserAttributesMapper());
    }

    @Cacheable(value={"ldapoutree"})
    public List<String> findOuTree(String userid) {
        LOG.debug("Get LDAP ou tree for user {}.", (Object)userid);
        List usersObjectPathList = this.searchObjectPaths(userid);
        if (usersObjectPathList.size() > 1) {
            log.warn("More than one entry found for user: {}", (Object)userid);
        }
        if (usersObjectPathList.size() == 0) {
            throw new IllegalArgumentException(String.format("OU tree for user with id %s not available", userid));
        }
        List ouTreeItems = this.initOuTreeItems();
        LdapName ldapName = (LdapName)usersObjectPathList.get(0);
        for (int i = 0; i < ldapName.getRdns().size(); ++i) {
            if (!ldapName.getRdn(i).getType().equals(LDAP_TYPE_OU)) {
                log.debug("Ignoring ldap objectpath entry: {}", (Object)ldapName.getRdn(i));
                continue;
            }
            List ouShortnames = this.searchOuShortnames(ldapName, i);
            if (ouShortnames.isEmpty()) continue;
            ouTreeItems.addAll(ouShortnames);
        }
        log.info("OU tree for user {}: {}", (Object)userid, (Object)String.join((CharSequence)", ", ouTreeItems));
        return ouTreeItems;
    }

    @Cacheable(value={"ldapous"})
    public Optional<User> findOuByShortName(String shortName) {
        LOG.debug("Get LDAP ou of {}.", (Object)shortName);
        LdapQuery query = this.ldapQueryFactory.createOuByShortNameQuery(shortName);
        List ous = super.search(query, (AttributesMapper)new UserAttributesMapper());
        if (ous.size() == 1) {
            return Optional.ofNullable((User)ous.get(0));
        }
        if (ous.isEmpty()) {
            LOG.warn("No ou with shortname {} in LDAP found.", (Object)shortName);
            return Optional.empty();
        }
        LOG.warn("More than one ou with shortname {} in LDAP found.", (Object)shortName);
        return Optional.empty();
    }

    private List<String> searchOuShortnames(LdapName ldapName, int rdnIndex) {
        String parentPath;
        String ou = ldapName.getRdn(rdnIndex).getValue().toString();
        List ouShortnames = this.searchOusShortname(ou, parentPath = this.buildObjectPath(ldapName, rdnIndex - 1));
        if (ouShortnames != null && !ouShortnames.isEmpty()) {
            List<String> cleanedOuShortnames = ouShortnames.stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (cleanedOuShortnames.size() > 1) {
                log.warn("More than 1 ou for {} in {}", (Object)ou, (Object)parentPath);
            }
            return cleanedOuShortnames;
        }
        log.warn("No ou found for {} in {}", (Object)ou, (Object)parentPath);
        return Collections.emptyList();
    }

    private List<String> initOuTreeItems() {
        ArrayList<String> ouTreeItems = new ArrayList<String>();
        ouTreeItems.add("LHM");
        return ouTreeItems;
    }

    private List<String> searchOusShortname(String ou, String parentPath) {
        LdapQuery query = this.ldapQueryFactory.createOuByNameAndParentPathQuery(ou, parentPath);
        return this.search(query, attrs -> {
            if (null != attrs.get("lhmOuShortName")) {
                return (String)attrs.get("lhmOuShortName").get();
            }
            return null;
        });
    }

    private List<LdapName> searchObjectPaths(String lhmObjectId) {
        LdapQuery query = this.ldapQueryFactory.createPersonByObjectIdQuery(lhmObjectId);
        return this.search(query, attrs -> new LdapName((String)attrs.get("lhmObjectPath").get()));
    }

    private String buildObjectPath(LdapName ldapName, int pos) {
        StringBuilder buf = new StringBuilder();
        for (int i = pos; i >= 0; --i) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(ldapName.get(i));
        }
        return buf.toString();
    }
}

